/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.broker.objects.OaBrokerRelatedDatasource;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.broker.oa.util.DatasourceRelationsAccumulator;
import eu.dnetlib.dhp.broker.oa.util.aggregators.withRels.RelatedDatasource;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple3;

public class PrepareRelatedDatasourcesJob {
    private static final Logger log = LoggerFactory.getLogger(PrepareRelatedDatasourcesJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)PrepareRelatedDatasourcesJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/common_params.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String graphPath = parser.get("graphPath");
        log.info("graphPath: {}", (Object)graphPath);
        String workingDir = parser.get("workingDir");
        log.info("workingDir: {}", (Object)workingDir);
        String relsPath = workingDir + "/relatedDatasources";
        log.info("relsPath: {}", (Object)relsPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            ClusterUtils.removeDir(spark, relsPath);
            LongAccumulator total = spark.sparkContext().longAccumulator("total_datasources");
            org.apache.spark.sql.Dataset rels = PrepareRelatedDatasourcesJob.prepareResultTuples(spark, graphPath, Publication.class).union(PrepareRelatedDatasourcesJob.prepareResultTuples(spark, graphPath, Dataset.class)).union(PrepareRelatedDatasourcesJob.prepareResultTuples(spark, graphPath, Software.class)).union(PrepareRelatedDatasourcesJob.prepareResultTuples(spark, graphPath, OtherResearchProduct.class));
            org.apache.spark.sql.Dataset datasources = ClusterUtils.readPath(spark, graphPath + "/datasource", Datasource.class).map(ConversionUtils::oafDatasourceToBrokerDatasource, Encoders.bean(OaBrokerRelatedDatasource.class));
            org.apache.spark.sql.Dataset dataset = rels.joinWith(functions.broadcast((org.apache.spark.sql.Dataset)datasources), datasources.col("openaireId").equalTo((Object)rels.col("_2")), "inner").map((MapFunction & Serializable)t -> {
                RelatedDatasource r = new RelatedDatasource();
                r.setSource((String)((Tuple3)t._1)._1());
                r.setRelDatasource((OaBrokerRelatedDatasource)t._2);
                r.getRelDatasource().setRelType((String)((Tuple3)t._1)._3());
                return r;
            }, Encoders.bean(RelatedDatasource.class));
            ClusterUtils.save(dataset, relsPath, RelatedDatasource.class, total);
        });
    }

    private static final <T extends Result> org.apache.spark.sql.Dataset<Tuple3<String, String, String>> prepareResultTuples(SparkSession spark, String graphPath, Class<T> sourceClass) {
        return ClusterUtils.readPath(spark, graphPath + "/" + sourceClass.getSimpleName().toLowerCase(), sourceClass).filter((FilterFunction & Serializable)r -> !ClusterUtils.isDedupRoot(r.getId())).filter((FilterFunction & Serializable)r -> r.getDataInfo().getDeletedbyinference()).map(DatasourceRelationsAccumulator::calculateTuples, Encoders.bean(DatasourceRelationsAccumulator.class)).flatMap((FlatMapFunction & Serializable)acc -> acc.getRels().iterator(), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING(), (Encoder)Encoders.STRING()));
    }
}

