/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.oa.util.BrokerIndexClient;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.index.es.ConvertJSONWithId;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexEventSubsetJob {
    private static final Logger log = LoggerFactory.getLogger(IndexEventSubsetJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)IndexEventSubsetJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/index_event_subset.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        String eventsSubsetPath = parser.get("outputDir") + "/events_subset";
        log.info("eventsSubsetPath: {}", (Object)eventsSubsetPath);
        String index = parser.get("index");
        log.info("index: {}", (Object)index);
        String indexHost = parser.get("esHost");
        log.info("indexHost: {}", (Object)indexHost);
        SparkSession spark = SparkSession.builder().config(conf).getOrCreate();
        Long date = ((Event)ClusterUtils.readPath(spark, eventsSubsetPath, Event.class).first()).getCreationDate();
        try (BrokerIndexClient feeder = new BrokerIndexClient(indexHost);){
            FileSystem fileSystem = FileSystem.get((Configuration)new Configuration());
            List<Path> files = ClusterUtils.listFiles(eventsSubsetPath, fileSystem, ".gz");
            log.info("*** Start indexing " + files.size() + " files");
            feeder.parallelBulkIndex(files, 4, fileSystem, (Function)new ConvertJSONWithId("\"eventId\":\"((\\d|\\w)*)\"", index));
            log.info("*** Deleting old events");
            feeder.deleteUsingDateBefore(index, "creationDate", date - 1000L, true);
            feeder.refreshIndex(index);
        }
        log.info("*** ALL DONE");
    }
}

