/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.application;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.OptionsParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgumentApplicationParser
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ArgumentApplicationParser.class);
    private final Options options = new Options();
    private final Map<String, String> objectMap = new HashMap<String, String>();
    private final List<String> compressedValues = new ArrayList<String>();

    public ArgumentApplicationParser(String json_configuration) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        OptionsParameter[] configuration = (OptionsParameter[])mapper.readValue(json_configuration, OptionsParameter[].class);
        this.createOptionMap(configuration);
    }

    public ArgumentApplicationParser(OptionsParameter[] configuration) {
        this.createOptionMap(configuration);
    }

    private void createOptionMap(OptionsParameter[] configuration) {
        Arrays.stream(configuration).map(conf -> {
            Option o = new Option(conf.getParamName(), true, conf.getParamDescription());
            o.setLongOpt(conf.getParamLongName());
            o.setRequired(conf.isParamRequired());
            if (conf.isCompressed()) {
                this.compressedValues.add(conf.getParamLongName());
            }
            return o;
        }).forEach(arg_0 -> ((Options)this.options).addOption(arg_0));
    }

    public static String decompressValue(String abstractCompressed) {
        try {
            byte[] byteArray = org.apache.commons.codec.binary.Base64.decodeBase64((byte[])abstractCompressed.getBytes());
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(byteArray));
            StringWriter stringWriter = new StringWriter();
            IOUtils.copy((InputStream)gis, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            log.error("Wrong value to decompress: {}", (Object)abstractCompressed);
            throw new IllegalArgumentException(e);
        }
    }

    public static String compressArgument(String value) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(value.getBytes());
        gzip.close();
        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    public void parseArgument(String[] args) throws ParseException {
        BasicParser parser = new BasicParser();
        CommandLine cmd = parser.parse(this.options, args);
        Arrays.stream(cmd.getOptions()).forEach(it -> this.objectMap.put(it.getLongOpt(), this.compressedValues.contains(it.getLongOpt()) ? ArgumentApplicationParser.decompressValue(it.getValue()) : it.getValue()));
    }

    public String get(String key) {
        return this.objectMap.get(key);
    }

    public Map<String, String> getObjectMap() {
        return this.objectMap;
    }
}

