/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common;

import eu.dnetlib.dhp.common.ThrowingSupport;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsSupport {
    private static final Logger logger = LoggerFactory.getLogger(HdfsSupport.class);

    private HdfsSupport() {
    }

    public static boolean exists(String path, Configuration configuration) {
        logger.info("Checking existence for path: {}", (Object)path);
        return ThrowingSupport.rethrowAsRuntimeException(() -> {
            Path f = new Path(path);
            FileSystem fileSystem = FileSystem.get((Configuration)configuration);
            return fileSystem.exists(f);
        });
    }

    public static void remove(String path, Configuration configuration) {
        logger.info("Removing path: {}", (Object)path);
        ThrowingSupport.rethrowAsRuntimeException(() -> {
            Path f = new Path(path);
            FileSystem fileSystem = FileSystem.get((Configuration)configuration);
            if (fileSystem.exists(f)) {
                fileSystem.delete(f, true);
            }
        });
    }

    public static List<String> listFiles(String path, Configuration configuration) {
        logger.info("Listing files in path: {}", (Object)path);
        return ThrowingSupport.rethrowAsRuntimeException(() -> Arrays.stream(FileSystem.get((Configuration)configuration).listStatus(new Path(path))).filter(FileStatus::isDirectory).map(x -> x.getPath().toString()).collect(Collectors.toList()));
    }
}

