/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common.aggregation;

import eu.dnetlib.dhp.message.MessageSender;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatorReport
extends LinkedHashMap<String, String>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AggregatorReport.class);
    private transient MessageSender messageSender;

    public AggregatorReport() {
    }

    public AggregatorReport(MessageSender messageSender) {
        this.messageSender = messageSender;
    }

    public void ongoing(Long current, Long total) {
        this.messageSender.sendMessage(current, total);
    }

    @Override
    public void close() throws IOException {
        if (Objects.nonNull(this.messageSender)) {
            log.info("closing report: ");
            this.forEach((k, v) -> log.info("{} - {}", k, v));
            HashMap<String, String> m = new HashMap<String, String>();
            m.put(this.getClass().getSimpleName().toLowerCase(), DHPUtils.MAPPER.writeValueAsString(this.values()));
            this.messageSender.sendReport(m);
        }
    }
}

