/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.WordUtils;

public class PacePerson {
    private List<String> name;
    private List<String> surname;
    private List<String> fullname;
    private final String original;
    private static Set<String> particles;

    public static String capitalize(String s) {
        if (particles.contains(s)) {
            return s;
        }
        return WordUtils.capitalize((String)s.toLowerCase(), (char[])new char[]{' ', '-'});
    }

    public static String dotAbbreviations(String s) {
        return s.length() == 1 ? s + "." : s;
    }

    public PacePerson(String s, boolean aggressive) {
        block10: {
            block8: {
                String[] arr;
                block9: {
                    this.name = Lists.newArrayList();
                    this.surname = Lists.newArrayList();
                    this.fullname = Lists.newArrayList();
                    this.original = s;
                    s = Normalizer.normalize(s, Normalizer.Form.NFD);
                    s = s.replaceAll("\\(.+\\)", "");
                    s = s.replaceAll("\\[.+\\]", "");
                    s = s.replaceAll("\\{.+\\}", "");
                    s = s.replaceAll("\\s+-\\s+", "-");
                    s = s.replaceAll("[\\p{Punct}&&[^,-]]", " ");
                    s = s.replaceAll("\\d", " ");
                    s = s.replaceAll("\\n", " ");
                    s = s.replaceAll("\\.", " ");
                    s = s.replaceAll("\\s+", " ");
                    if (aggressive) {
                        s = s.replaceAll("[\\p{InCombiningDiacriticalMarks}&&[^,-]]", "");
                    }
                    if (!s.contains(",")) break block8;
                    arr = s.split(",");
                    if (arr.length != 1) break block9;
                    this.fullname = this.splitTerms(arr[0]);
                    break block10;
                }
                if (arr.length <= 1) break block10;
                this.surname = this.splitTerms(arr[0]);
                this.name = this.splitTerms(arr[1]);
                this.fullname.addAll(this.surname);
                this.fullname.addAll(this.name);
                break block10;
            }
            this.fullname = this.splitTerms(s);
            int lastInitialPosition = this.fullname.size();
            boolean hasSurnameInUpperCase = false;
            for (int i = 0; i < this.fullname.size(); ++i) {
                String term = this.fullname.get(i);
                if (term.length() == 1) {
                    lastInitialPosition = i;
                    continue;
                }
                if (!term.equals(term.toUpperCase())) continue;
                hasSurnameInUpperCase = true;
            }
            if (lastInitialPosition < this.fullname.size() - 1) {
                this.name = this.fullname.subList(0, lastInitialPosition + 1);
                this.surname = this.fullname.subList(lastInitialPosition + 1, this.fullname.size());
            } else if (hasSurnameInUpperCase) {
                for (String term : this.fullname) {
                    if (term.length() > 1 && term.equals(term.toUpperCase())) {
                        this.surname.add(term);
                        continue;
                    }
                    this.name.add(term);
                }
            }
        }
    }

    private List<String> splitTerms(String s) {
        ArrayList list = Lists.newArrayList();
        for (String part : Splitter.on((String)" ").omitEmptyStrings().split((CharSequence)s)) {
            if (particles.contains(part.toLowerCase())) continue;
            list.add(part);
        }
        return list;
    }

    public List<String> getName() {
        return this.name;
    }

    public String getNameString() {
        return Joiner.on((String)" ").join(this.getName());
    }

    public List<String> getSurname() {
        return this.surname;
    }

    public List<String> getFullname() {
        return this.fullname;
    }

    public String getOriginal() {
        return this.original;
    }

    public String hash() {
        return Hashing.murmur3_128().hashString((CharSequence)this.getNormalisedFullname(), StandardCharsets.UTF_8).toString();
    }

    public String getNormalisedFirstName() {
        return Joiner.on((String)" ").join(this.getCapitalFirstnames());
    }

    public String getNormalisedSurname() {
        return Joiner.on((String)" ").join(this.getCapitalSurname());
    }

    public String getSurnameString() {
        return Joiner.on((String)" ").join(this.getSurname());
    }

    public String getNormalisedFullname() {
        return this.isAccurate() ? this.getNormalisedSurname() + ", " + this.getNormalisedFirstName() : Joiner.on((String)" ").join(this.fullname);
    }

    public List<String> getCapitalFirstnames() {
        return Optional.ofNullable(this.getNameWithAbbreviations()).map(name -> name.stream().map(PacePerson::capitalize).collect(Collectors.toList())).orElse(new ArrayList());
    }

    public List<String> getCapitalSurname() {
        return Optional.ofNullable(this.getSurname()).map(surname -> surname.stream().map(PacePerson::capitalize).collect(Collectors.toList())).orElse(new ArrayList());
    }

    public List<String> getNameWithAbbreviations() {
        return Optional.ofNullable(this.getName()).map(name -> name.stream().map(PacePerson::dotAbbreviations).collect(Collectors.toList())).orElse(new ArrayList());
    }

    public boolean isAccurate() {
        return this.name != null && this.surname != null && !this.name.isEmpty() && !this.surname.isEmpty();
    }

    static {
        try {
            particles = new HashSet<String>(IOUtils.readLines((InputStream)PacePerson.class.getResourceAsStream("/eu/dnetlib/dhp/common/name_particles.txt")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

