/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.utils;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISLookupClientFactory {
    private static final Logger log = LoggerFactory.getLogger(ISLookupClientFactory.class);
    private static final int requestTimeout = 600000;
    private static final int connectTimeout = 600000;

    private ISLookupClientFactory() {
    }

    public static ISLookUpService getLookUpService(String isLookupUrl) {
        return ISLookupClientFactory.getServiceStub(ISLookUpService.class, isLookupUrl);
    }

    private static <T> T getServiceStub(Class<T> clazz, String endpoint) {
        log.info("creating {} stub from {}", (Object)clazz.getName(), (Object)endpoint);
        JaxWsProxyFactoryBean jaxWsProxyFactory = new JaxWsProxyFactoryBean();
        jaxWsProxyFactory.setServiceClass(clazz);
        jaxWsProxyFactory.setAddress(endpoint);
        Object service = jaxWsProxyFactory.create();
        Client client = ClientProxy.getClient((Object)service);
        if (client != null) {
            HTTPConduit conduit = (HTTPConduit)client.getConduit();
            HTTPClientPolicy policy = new HTTPClientPolicy();
            log.info("setting connectTimeout to {}, requestTimeout to {} for service {}", new Object[]{600000, 600000, clazz.getCanonicalName()});
            policy.setConnectionTimeout(600000L);
            policy.setReceiveTimeout(600000L);
            conduit.setClient(policy);
        }
        return (T)service;
    }
}

