/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import eu.dnetlib.dhp.schema.mdstore.MDStoreWithInfo;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.utils.GraphUriScheme;
import eu.dnetlib.dhp.utils.InputType;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minidev.json.JSONArray;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class DHPUtils {
    private static final Logger log = LoggerFactory.getLogger(DHPUtils.class);
    public static final ObjectMapper MAPPER = new ObjectMapper();

    private DHPUtils() {
    }

    public static Seq<String> toSeq(List<String> list) {
        return ((Iterator)JavaConverters.asScalaIteratorConverter(list.iterator()).asScala()).toSeq();
    }

    public static String md5(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes(StandardCharsets.UTF_8));
            return new String(Hex.encodeHex((byte[])md.digest()));
        }
        catch (Exception e) {
            log.error("Error creating id from {}", (Object)s);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static Set<String> mdstorePaths(String mdstoreManagerUrl, String format, String layout, String interpretation, boolean includeEmpty) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String generateIdentifier(String originalId, String nsPrefix) {
        return String.format("%s::%s", nsPrefix, DHPUtils.md5(originalId));
    }

    public static String getJPathString(String jsonPath, String json) {
        try {
            Object o = JsonPath.read((String)json, (String)jsonPath, (Predicate[])new Predicate[0]);
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof JSONArray && ((JSONArray)o).size() > 0) {
                return (String)((JSONArray)o).get(0);
            }
            return o.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void writeHdfsFile(Configuration conf, String content, String path) throws IOException {
        log.info("writing file {}, size {}", (Object)path, (Object)content);
        try (FileSystem fs = FileSystem.get((Configuration)conf);
             BufferedOutputStream os = new BufferedOutputStream((OutputStream)fs.create(new Path(path)));){
            os.write(content.getBytes(StandardCharsets.UTF_8));
            os.flush();
        }
    }

    public static String readHdfsFile(Configuration conf, String path) throws IOException {
        log.info("reading file {}", (Object)path);
        try (FileSystem fs = FileSystem.get((Configuration)conf);){
            Path p = new Path(path);
            if (!fs.exists(p)) {
                throw new FileNotFoundException(path);
            }
            String string = IOUtils.toString((InputStream)fs.open(p));
            return string;
        }
    }

    public static <T> T readHdfsFileAs(Configuration conf, String path, Class<T> clazz) throws IOException {
        return (T)MAPPER.readValue(DHPUtils.readHdfsFile(conf, path), clazz);
    }

    public static <T> void saveDataset(Dataset<T> mdstore, String targetPath) {
        log.info("saving dataset in: {}", (Object)targetPath);
        mdstore.write().mode(SaveMode.Overwrite).format("parquet").save(targetPath);
    }

    public static Configuration getHadoopConfiguration(String nameNode) {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", nameNode);
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        System.setProperty("hadoop.home.dir", "/");
        return conf;
    }

    public static void populateOOZIEEnv(Map<String, String> report) throws IOException {
        File file = new File(System.getProperty("oozie.action.output.properties"));
        Properties props = new Properties();
        report.forEach((k, v) -> props.setProperty((String)k, (String)v));
        try (FileOutputStream os = new FileOutputStream(file);){
            props.store(os, "");
        }
    }

    public static void populateOOZIEEnv(String paramName, String value) throws IOException {
        HashMap report = Maps.newHashMap();
        report.put(paramName, value);
        DHPUtils.populateOOZIEEnv(report);
    }

    private static <T extends Oaf> Dataset<Row> _readGraph(SparkSession spark, URI input, Class<T> entityClazz, Encoder<T> encoder) {
        log.info("reading graph from {}", (Object)input);
        GraphUriScheme scheme = StringUtils.isBlank((CharSequence)input.getScheme()) ? GraphUriScheme.FILE : GraphUriScheme.valueOf(input.getScheme().toUpperCase());
        switch (scheme) {
            case HDFS: 
            case S3A: 
            case FILE: {
                String path = input + "/" + entityClazz.getSimpleName().toLowerCase();
                return spark.read().schema(encoder.schema()).json(path);
            }
            case HIVE: {
                java.util.Iterator pathParts = Splitter.on((String)"/").omitEmptyStrings().trimResults().split((CharSequence)input.getPath()).iterator();
                if (!pathParts.hasNext()) {
                    throw new IllegalArgumentException("Invalid path: " + input.getPath());
                }
                String dbName = (String)pathParts.next();
                return spark.read().table(dbName + "." + entityClazz.getSimpleName().toLowerCase());
            }
        }
        throw new IllegalArgumentException("Unsupported input URI scheme: " + input.getScheme());
    }

    private static <T extends Oaf> Dataset<Row> _readGraph(SparkSession spark, InputType inputType, String input, Class<T> entityClazz, Encoder<T> encoder) {
        switch (inputType) {
            case HDFS_JSON: {
                return spark.read().schema(encoder.schema()).json(input + "/" + entityClazz.getSimpleName().toLowerCase());
            }
            case DB_PARQUET: {
                return spark.read().table(input + "." + entityClazz.getSimpleName().toLowerCase());
            }
        }
        throw new IllegalArgumentException("Unsupported inputType: " + (Object)((Object)inputType));
    }

    public static <T extends Oaf> Dataset<Row> readGraph(SparkSession spark, InputType inputType, String input, Class<T> entityClazz) {
        Encoder encoder = Encoders.bean(entityClazz);
        return DHPUtils._readGraph(spark, inputType, input, entityClazz, encoder);
    }

    public static <T extends Oaf> Dataset<T> readGraphAs(SparkSession spark, InputType inputType, String input, Class<T> entityClazz) {
        Encoder encoder = Encoders.bean(entityClazz);
        return DHPUtils._readGraph(spark, inputType, input, entityClazz, encoder).as(encoder);
    }

    private static /* synthetic */ String lambda$mdstorePaths$6(MDStoreWithInfo md) {
        return md.getHdfsPath() + "/" + md.getCurrentVersion() + "/store";
    }

    private static /* synthetic */ boolean lambda$mdstorePaths$5(boolean includeEmpty, MDStoreWithInfo md) {
        return includeEmpty || md.getSize() > 0L;
    }

    private static /* synthetic */ boolean lambda$mdstorePaths$4(MDStoreWithInfo md) {
        return StringUtils.isNotBlank((CharSequence)md.getCurrentVersion());
    }

    private static /* synthetic */ boolean lambda$mdstorePaths$3(MDStoreWithInfo md) {
        return StringUtils.isNotBlank((CharSequence)md.getHdfsPath());
    }

    private static /* synthetic */ boolean lambda$mdstorePaths$2(String interpretation, MDStoreWithInfo md) {
        return md.getInterpretation().equalsIgnoreCase(interpretation);
    }

    private static /* synthetic */ boolean lambda$mdstorePaths$1(String layout, MDStoreWithInfo md) {
        return md.getLayout().equalsIgnoreCase(layout);
    }

    private static /* synthetic */ boolean lambda$mdstorePaths$0(String format, MDStoreWithInfo md) {
        return md.getFormat().equalsIgnoreCase(format);
    }
}

