/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.utils;

import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.sx.OafUtils$;
import eu.dnetlib.dhp.utils.ORCIDAuthorEnricherResult;
import eu.dnetlib.dhp.utils.OrcidAuthor;
import eu.openaire.common.author.AuthorMatch;
import eu.openaire.common.author.AuthorMatcherStep;
import eu.openaire.common.author.AuthorMatchers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.StringBuilder;

public final class ORCIDAuthorEnricher$
implements Serializable {
    public static final ORCIDAuthorEnricher$ MODULE$;

    static {
        new ORCIDAuthorEnricher$();
    }

    public ORCIDAuthorEnricherResult enrichOrcid(String id, List<Author> graph_authors, List<OrcidAuthor> orcid_authors, String classid, String provenance) {
        Predicate<List<AuthorMatch<Author, OrcidAuthor>>> hasAffiliations = new Predicate<List<AuthorMatch<Author, OrcidAuthor>>>(){

            public boolean test(List<AuthorMatch<Author, OrcidAuthor>> t) {
                List baseAffiliations = ((Author)t.get(0).getBaseAuthor()).getRawAffiliationString();
                return baseAffiliations == null || baseAffiliations.isEmpty() ? ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(t).asScala()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AuthorMatch<Author, OrcidAuthor> m) {
                        return ((Author)m.getBaseAuthor()).getRawAffiliationString() != null && !((Author)m.getBaseAuthor()).getRawAffiliationString().isEmpty();
                    }
                }) : ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(t).asScala()).exists((Function1)new Serializable(this, baseAffiliations){
                    public static final long serialVersionUID = 0L;
                    private final List baseAffiliations$1;

                    public final boolean apply(AuthorMatch<Author, OrcidAuthor> m) {
                        return ((Author)m.getBaseAuthor()).getRawAffiliationString() == null || ((Author)m.getBaseAuthor()).getRawAffiliationString().size() != this.baseAffiliations$1.size() || !this.baseAffiliations$1.containsAll(((Author)m.getBaseAuthor()).getRawAffiliationString());
                    }
                    {
                        this.baseAffiliations$1 = baseAffiliations$1;
                    }
                });
            }
        };
        Function<Author, String> authorFullNameExtractor = new Function<Author, String>(){

            public String apply(Author author) {
                return author.getFullname();
            }
        };
        Function<OrcidAuthor, String> orcidFullNameExtractor = new Function<OrcidAuthor, String>(){

            public String apply(OrcidAuthor orcid) {
                return new StringBuilder().append((Object)orcid.givenName()).append((Object)" ").append((Object)orcid.familyName()).toString();
            }
        };
        List result = AuthorMatchers.findMatches(graph_authors, orcid_authors, Arrays.asList((Object[])new AuthorMatcherStep[]{AuthorMatcherStep.stringIgnoreCaseMatcher((Function)authorFullNameExtractor, (Function)orcidFullNameExtractor).name("fullName").exclusionPredicate((Predicate)hasAffiliations).build(), AuthorMatcherStep.stringIgnoreCaseMatcher((Function)authorFullNameExtractor, (Function)new Function<OrcidAuthor, String>(){

            public String apply(OrcidAuthor orcid) {
                return new StringBuilder().append((Object)orcid.familyName()).append((Object)" ").append((Object)orcid.givenName()).toString();
            }
        }).name("reversedFullName").exclusionPredicate((Predicate)hasAffiliations).build(), AuthorMatcherStep.abbreviationsMatcher((Function)authorFullNameExtractor, (Function)orcidFullNameExtractor).name("orderedTokens").exclusionPredicate((Predicate)hasAffiliations).build(), AuthorMatcherStep.stringIgnoreCaseMatcher((Function)authorFullNameExtractor, (Function)new Function<OrcidAuthor, String>(){

            public String apply(OrcidAuthor orcid) {
                return orcid.creditName();
            }
        }).name("creditName").exclusionPredicate((Predicate)hasAffiliations).build(), new AuthorMatcherStep.Builder().name("otherNames").matchingFunc((BiFunction)new BiFunction<Author, OrcidAuthor, Optional<AuthorMatch<Author, OrcidAuthor>>>(){

            public Optional<AuthorMatch<Author, OrcidAuthor>> apply(Author author, OrcidAuthor orcid) {
                return orcid.otherNames() != null && ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(orcid.otherNames()).asScala()).exists((Function1)new Serializable(this, author){
                    public static final long serialVersionUID = 0L;
                    private final Author author$1;

                    public final boolean apply(String otherName) {
                        return AuthorMatchers.matchEqualsIgnoreCase((String)this.author$1.getFullname(), (String)otherName);
                    }
                    {
                        this.author$1 = author$1;
                    }
                }) ? Optional.of(AuthorMatch.of((Object)author, (Object)orcid, (double)1.0)) : Optional.empty();
            }
        }).exclusionPredicate((Predicate)hasAffiliations).build()}));
        ArrayList<Author> unmatched_authors = new ArrayList<Author>(graph_authors);
        ArrayList<OrcidAuthor> unmatched_orcid = new ArrayList<OrcidAuthor>(orcid_authors);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result).asScala()).foreach((Function1)new Serializable(classid, provenance, unmatched_authors, unmatched_orcid){
            public static final long serialVersionUID = 0L;
            private final String classid$1;
            private final String provenance$1;
            private final ArrayList unmatched_authors$1;
            private final ArrayList unmatched_orcid$1;

            public final boolean apply(AuthorMatch<Author, OrcidAuthor> m) {
                this.unmatched_authors$1.remove(m.getBaseAuthor());
                this.unmatched_orcid$1.remove(m.getEnrichingAuthor());
                if (((Author)m.getBaseAuthor()).getPid() == null) {
                    ((Author)m.getBaseAuthor()).setPid(new ArrayList<E>());
                }
                StructuredProperty orcidPID = OafUtils$.MODULE$.createSP(((OrcidAuthor)m.getEnrichingAuthor()).orcid(), this.classid$1, this.classid$1);
                orcidPID.setDataInfo(OafUtils$.MODULE$.generateDataInfo(OafUtils$.MODULE$.generateDataInfo$default$1(), OafUtils$.MODULE$.generateDataInfo$default$2()));
                if (this.provenance$1.equalsIgnoreCase("propagation")) {
                    orcidPID.getDataInfo().setInferenceprovenance("propagation");
                    orcidPID.getDataInfo().setInferred(Predef$.MODULE$.boolean2Boolean(true));
                    orcidPID.getDataInfo().setProvenanceaction(OafUtils$.MODULE$.createQualifier("authorpid:result", "Propagation of authors pid to result through semantic relations"));
                } else {
                    orcidPID.getDataInfo().setProvenanceaction(OafUtils$.MODULE$.createQualifier(this.provenance$1, this.provenance$1));
                }
                return ((Author)m.getBaseAuthor()).getPid().add(orcidPID);
            }
            {
                this.classid$1 = classid$1;
                this.provenance$1 = provenance$1;
                this.unmatched_authors$1 = unmatched_authors$1;
                this.unmatched_orcid$1 = unmatched_orcid$1;
            }
        });
        return new ORCIDAuthorEnricherResult(id, graph_authors, result, unmatched_authors, unmatched_orcid);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ORCIDAuthorEnricher$() {
        MODULE$ = this;
    }
}

