/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common.collection;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.opencsv.bean.CsvToBeanBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class GetCSV {
    public static final char DEFAULT_DELIMITER = ',';

    private GetCSV() {
    }

    public static void getCsv(FileSystem fileSystem, BufferedReader reader, String hdfsPath, String modelClass) throws IOException, ClassNotFoundException {
        GetCSV.getCsv(fileSystem, reader, hdfsPath, modelClass, ',');
    }

    public static void getCsv(FileSystem fileSystem, Reader reader, String hdfsPath, String modelClass, char delimiter) throws IOException, ClassNotFoundException {
        Path hdfsWritePath = new Path(hdfsPath);
        FSDataOutputStream fsDataOutputStream = null;
        if (fileSystem.exists(hdfsWritePath)) {
            fileSystem.delete(hdfsWritePath, false);
        }
        fsDataOutputStream = fileSystem.create(hdfsWritePath);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fsDataOutputStream, StandardCharsets.UTF_8));){
            ObjectMapper mapper = new ObjectMapper();
            List lines = new CsvToBeanBuilder(reader).withType(Class.forName(modelClass)).withSeparator(delimiter).build().parse();
            for (Object line : lines) {
                writer.write(mapper.writeValueAsString(line));
                writer.newLine();
            }
        }
    }
}

