/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakeTarArchive
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MakeTarArchive.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)MakeTarArchive.class.getResourceAsStream("/eu/dnetlib/dhp/common/input_maketar_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        String outputPath = parser.get("hdfsPath");
        log.info("hdfsPath: {}", (Object)outputPath);
        String hdfsNameNode = parser.get("nameNode");
        log.info("nameNode: {}", (Object)hdfsNameNode);
        String inputPath = parser.get("sourcePath");
        log.info("input path : {}", (Object)inputPath);
        int gBperSplit = Optional.ofNullable(parser.get("splitSize")).map(Integer::valueOf).orElse(10);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", hdfsNameNode);
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        MakeTarArchive.makeTArArchive(fileSystem, inputPath, outputPath, gBperSplit);
    }

    public static void makeTArArchive(FileSystem fileSystem, String inputPath, String outputPath, int gBperSplit) throws IOException {
        RemoteIterator dirIterator = fileSystem.listLocatedStatus(new Path(inputPath));
        while (dirIterator.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)dirIterator.next();
            Path p = fileStatus.getPath();
            String pathString = p.toString();
            String entity = pathString.substring(pathString.lastIndexOf("/") + 1);
            MakeTarArchive.tarMaxSize(fileSystem, pathString, outputPath + "/" + entity, entity, gBperSplit);
        }
    }

    private static TarArchiveOutputStream getTar(FileSystem fileSystem, String outputPath) throws IOException {
        Path hdfsWritePath = new Path(outputPath);
        if (fileSystem.exists(hdfsWritePath)) {
            fileSystem.delete(hdfsWritePath, true);
        }
        return new TarArchiveOutputStream(fileSystem.create(hdfsWritePath).getWrappedStream());
    }

    private static void write(FileSystem fileSystem, String inputPath, String outputPath, String dirName) throws IOException {
        Path hdfsWritePath = new Path(outputPath);
        if (fileSystem.exists(hdfsWritePath)) {
            fileSystem.delete(hdfsWritePath, true);
        }
        try (TarArchiveOutputStream ar = new TarArchiveOutputStream(fileSystem.create(hdfsWritePath).getWrappedStream());){
            RemoteIterator iterator = fileSystem.listFiles(new Path(inputPath), true);
            while (iterator.hasNext()) {
                MakeTarArchive.writeCurrentFile(fileSystem, dirName, (RemoteIterator<LocatedFileStatus>)iterator, ar, 0L);
            }
        }
    }

    public static void tarMaxSize(FileSystem fileSystem, String inputPath, String outputPath, String dir_name, int gBperSplit) throws IOException {
        long bytesPerSplit = 0x40000000L * (long)gBperSplit;
        long sourceSize = fileSystem.getContentSummary(new Path(inputPath)).getSpaceConsumed();
        if (sourceSize < bytesPerSplit) {
            MakeTarArchive.write(fileSystem, inputPath, outputPath + ".tar", dir_name);
        } else {
            int partNum = 0;
            RemoteIterator fileStatusListIterator = fileSystem.listFiles(new Path(inputPath), true);
            boolean next = fileStatusListIterator.hasNext();
            while (next) {
                TarArchiveOutputStream ar = MakeTarArchive.getTar(fileSystem, outputPath + "_" + (partNum + 1) + ".tar");
                Throwable throwable = null;
                try {
                    long currentSize = 0L;
                    while (next && currentSize < bytesPerSplit) {
                        currentSize = MakeTarArchive.writeCurrentFile(fileSystem, dir_name, (RemoteIterator<LocatedFileStatus>)fileStatusListIterator, ar, currentSize);
                        next = fileStatusListIterator.hasNext();
                    }
                    ++partNum;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ar == null) continue;
                    if (throwable != null) {
                        try {
                            ar.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ar.close();
                }
            }
        }
    }

    private static long writeCurrentFile(FileSystem fileSystem, String dirName, RemoteIterator<LocatedFileStatus> fileStatusListIterator, TarArchiveOutputStream ar, long currentSize) throws IOException {
        LocatedFileStatus fileStatus = (LocatedFileStatus)fileStatusListIterator.next();
        Path p = fileStatus.getPath();
        String pString = p.toString();
        if (!pString.endsWith("_SUCCESS")) {
            int count;
            String name = pString.substring(pString.lastIndexOf("/") + 1);
            if (name.startsWith("part-") & name.length() > 10) {
                String tmp = name.substring(0, 10);
                if (name.contains(".")) {
                    tmp = tmp + name.substring(name.indexOf("."));
                }
                name = tmp;
            }
            TarArchiveEntry entry = new TarArchiveEntry(dirName + "/" + name);
            entry.setSize(fileStatus.getLen());
            currentSize += fileStatus.getLen();
            ar.putArchiveEntry((ArchiveEntry)entry);
            FSDataInputStream is = fileSystem.open(fileStatus.getPath());
            BufferedInputStream bis = new BufferedInputStream((InputStream)is);
            byte[] data = new byte[1024];
            while ((count = bis.read(data, 0, data.length)) != -1) {
                ar.write(data, 0, count);
            }
            bis.close();
            ar.closeArchiveEntry();
        }
        return currentSize;
    }
}

