/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.utils.saxon;

import eu.dnetlib.dhp.utils.saxon.AbstractExtensionFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.apache.commons.lang3.StringUtils;

public class PickFirst
extends AbstractExtensionFunction {
    @Override
    public String getName() {
        return "pickFirst";
    }

    @Override
    public Sequence doCall(XPathContext context, Sequence[] arguments) throws XPathException {
        if (arguments == null | arguments.length == 0) {
            return new StringValue((CharSequence)"");
        }
        String s1 = this.getValue(arguments[0]);
        String s2 = this.getValue(arguments[1]);
        String value = StringUtils.isNotBlank((CharSequence)s1) ? s1 : (StringUtils.isNotBlank((CharSequence)s2) ? s2 : "");
        return new StringValue((CharSequence)value);
    }

    private String getValue(Sequence arg) throws XPathException {
        Item item;
        if (arg != null && (item = arg.head()) != null) {
            return item.getStringValue();
        }
        return "";
    }

    public int getMinimumNumberOfArguments() {
        return 0;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_ITEM};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }
}

