/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.parser.utility;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDNav;
import eu.dnetlib.dhp.parser.utility.VtdException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VtdUtilityParser {
    private VtdUtilityParser() {
    }

    public static List<Node> getTextValuesWithAttributes(AutoPilot ap, VTDNav vn, String xpath, List<String> attributes) throws VtdException {
        ArrayList<Node> results = new ArrayList<Node>();
        try {
            ap.selectXPath(xpath);
            while (ap.evalXPath() != -1) {
                Node currentNode = new Node();
                int t = vn.getText();
                if (t >= 0) {
                    currentNode.setTextValue(vn.toNormalizedString(t));
                }
                currentNode.setAttributes(VtdUtilityParser.getAttributes(vn, attributes));
                results.add(currentNode);
            }
            return results;
        }
        catch (Exception e) {
            throw new VtdException(e);
        }
    }

    private static Map<String, String> getAttributes(VTDNav vn, List<String> attributes) {
        HashMap<String, String> currentAttributes = new HashMap<String, String>();
        if (attributes != null) {
            attributes.forEach(attributeKey -> {
                try {
                    int attr = vn.getAttrVal(attributeKey);
                    if (attr > -1) {
                        currentAttributes.put((String)attributeKey, vn.toNormalizedString(attr));
                    }
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return currentAttributes;
    }

    public static List<String> getTextValue(AutoPilot ap, VTDNav vn, String xpath) throws VtdException {
        ArrayList<String> results = new ArrayList<String>();
        try {
            ap.selectXPath(xpath);
            while (ap.evalXPath() != -1) {
                int t = vn.getText();
                if (t <= -1) continue;
                results.add(vn.toNormalizedString(t));
            }
            return results;
        }
        catch (Exception e) {
            throw new VtdException(e);
        }
    }

    public static String getSingleValue(AutoPilot ap, VTDNav nav, String xpath) throws VtdException {
        try {
            ap.selectXPath(xpath);
            while (ap.evalXPath() != -1) {
                int it = nav.getText();
                if (it <= -1) continue;
                return nav.toNormalizedString(it);
            }
            return null;
        }
        catch (Exception e) {
            throw new VtdException(e);
        }
    }

    public static class Node {
        private String textValue;
        private Map<String, String> attributes;

        public String getTextValue() {
            return this.textValue;
        }

        public void setTextValue(String textValue) {
            this.textValue = textValue;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }
    }
}

