/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChangeProfile {
    static Set<String> activeProfiles = new HashSet<String>();
    static Set<String> inactiveProfiles = new HashSet<String>();

    public static void main(String[] args) throws Exception {
        String activate = null;
        String deactivate = null;
        String suffix = null;
        block10: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "--activate": {
                    activate = args[++i];
                    activeProfiles.addAll(Arrays.asList(activate.split(",")));
                    continue block10;
                }
                case "--deactivate": {
                    deactivate = args[++i];
                    inactiveProfiles.addAll(Arrays.asList(deactivate.split(",")));
                    continue block10;
                }
                case "--suffix": {
                    suffix = args[++i];
                }
            }
        }
        if (activate == null) {
            System.err.println("Missing required argument: --activate");
            System.exit(1);
        }
        if (suffix == null) {
            suffix = "";
        }
        List<Path> poms = ChangeProfile.findPomFiles(Paths.get(".", new String[0]));
        Collections.sort(poms);
        HashMap<String, String> artifactIdMap = new HashMap<String, String>();
        for (Path pom : poms) {
            Document doc = ChangeProfile.loadXml(pom);
            String artifactId = ChangeProfile.getArtifactId(doc);
            String newId = ChangeProfile.transformArtifactId(artifactId, suffix);
            artifactIdMap.put(artifactId, newId);
        }
        for (Path pom : poms) {
            System.out.println("\ud83d\udd27 Updating: " + pom);
            ChangeProfile.rewritePom(pom, artifactIdMap);
        }
        System.out.println("\u2705 Done updating all pom.xml files.");
    }

    static String transformArtifactId(String id, String suffix) {
        int lastUnderscore = id.lastIndexOf(95);
        if (lastUnderscore > 0) {
            id = id.substring(0, lastUnderscore);
        }
        if (suffix.isEmpty()) {
            return id;
        }
        return id + "_" + suffix;
    }

    static List<Path> findPomFiles(Path dir) throws IOException {
        try (Stream<Path> files = Files.walk(dir, new FileVisitOption[0]);){
            List<Path> list = files.filter(p -> p.getFileName().toString().equals("pom.xml")).collect(Collectors.toList());
            return list;
        }
    }

    static Document loadXml(Path path) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(path.toFile());
    }

    static String getArtifactId(Document doc) {
        NodeList list = doc.getElementsByTagName("project").item(0).getChildNodes();
        for (int j = 0; j < list.getLength(); ++j) {
            Node pnode = list.item(j);
            if (!pnode.getNodeName().equals("artifactId")) continue;
            return pnode.getTextContent().trim();
        }
        return "";
    }

    static String getText(Element doc, String tagName) {
        NodeList list = doc.getElementsByTagName(tagName);
        if (list.getLength() > 0) {
            return list.item(0).getTextContent().trim();
        }
        return null;
    }

    static void rewritePom(Path pomPath, Map<String, String> artifactIdMap) throws Exception {
        Document doc = ChangeProfile.loadXml(pomPath);
        NodeList aidNodes = doc.getElementsByTagName("project").item(0).getChildNodes();
        for (int i = 0; i < aidNodes.getLength(); ++i) {
            String original;
            Node node = aidNodes.item(i);
            if (node.getNodeName().equals("parent")) {
                NodeList pList = node.getChildNodes();
                for (int j = 0; j < pList.getLength(); ++j) {
                    Node pnode = pList.item(j);
                    if (!pnode.getNodeName().equals("artifactId")) continue;
                    node = pnode;
                    break;
                }
            }
            if (!node.getNodeName().equals("artifactId") || !artifactIdMap.containsKey(original = node.getTextContent().trim())) continue;
            node.setTextContent(artifactIdMap.get(original));
        }
        NodeList profiles = doc.getElementsByTagName("profile");
        for (int i = 0; i < profiles.getLength(); ++i) {
            Element active;
            Element activation;
            Element profile = (Element)profiles.item(i);
            String profileId = profile.getElementsByTagName("id").item(0).getTextContent().trim();
            if (activeProfiles.contains(profileId)) {
                activation = ChangeProfile.getOrCreateChild(profile, "activation");
                active = ChangeProfile.getOrCreateChild(activation, "activeByDefault");
                active.setTextContent("true");
                continue;
            }
            if (!inactiveProfiles.contains(profileId) || (activation = ChangeProfile.getChild(profile, "activation")) == null || (active = ChangeProfile.getOrCreateChild(activation, "activeByDefault")) == null) continue;
            active.setTextContent("false");
        }
        profiles = doc.getElementsByTagName("profile");
        Element projectProperties = ChangeProfile.getOrCreateChild(doc.getDocumentElement(), "properties");
        for (int i = 0; i < profiles.getLength(); ++i) {
            NodeList children;
            Element profile = (Element)profiles.item(i);
            String profileId = ChangeProfile.getText(profile, "id");
            if (!activeProfiles.contains(profileId) || (children = profile.getElementsByTagName("properties")).getLength() == 0) continue;
            Element profileProps = (Element)children.item(0);
            NodeList props = profileProps.getChildNodes();
            for (int j = 0; j < props.getLength(); ++j) {
                Node prop = props.item(j);
                if (prop.getNodeType() != 1) continue;
                String name = prop.getNodeName();
                String value = prop.getTextContent();
                Node existing = null;
                NodeList topProps = projectProperties.getElementsByTagName(name);
                for (int k = 0; k < topProps.getLength(); ++k) {
                    if (!topProps.item(k).getNodeName().equals(name)) continue;
                    existing = topProps.item(k);
                    break;
                }
                if (existing != null) {
                    projectProperties.removeChild(existing);
                }
                Element newProp = doc.createElement(name);
                newProp.setTextContent(value);
                projectProperties.appendChild(newProp);
            }
            System.out.println("\u2b06\ufe0f  Promoted properties from profile: " + profileId);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource src = new DOMSource(doc);
        StreamResult out = new StreamResult(pomPath.toFile());
        transformer.transform(src, out);
    }

    static Element getChild(Element parent, String tag) {
        NodeList children = parent.getElementsByTagName(tag);
        if (children.getLength() > 0) {
            return (Element)children.item(0);
        }
        return null;
    }

    static Element getOrCreateChild(Element parent, String tag) {
        NodeList children = parent.getElementsByTagName(tag);
        if (children.getLength() > 0) {
            return (Element)children.item(0);
        }
        Element newChild = parent.getOwnerDocument().createElement(tag);
        parent.appendChild(newChild);
        return newChild;
    }
}

