/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.merge;

import com.wcohen.ss.JaroWinkler;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.pace.model.Person;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import scala.Tuple2;

public class AuthorMerger {
    private static final Double THRESHOLD = 0.95;

    private AuthorMerger() {
    }

    public static List<Author> merge(List<List<Author>> authors) {
        authors.sort((o1, o2) -> -Integer.compare(AuthorMerger.countAuthorsPids(o1), AuthorMerger.countAuthorsPids(o2)));
        List<Author> author = new ArrayList<Author>();
        for (List<Author> a : authors) {
            author = AuthorMerger.mergeAuthor(author, a);
        }
        return author;
    }

    public static List<Author> mergeAuthor(List<Author> a, List<Author> b, Double threshold) {
        List<Author> enrich;
        List<Author> base;
        int sb;
        int pa = AuthorMerger.countAuthorsPids(a);
        int pb = AuthorMerger.countAuthorsPids(b);
        int sa = AuthorMerger.authorsSize(a);
        if (sa == (sb = AuthorMerger.authorsSize(b))) {
            base = pa > pb ? a : b;
            enrich = pa > pb ? b : a;
        } else {
            base = sa > sb ? a : b;
            enrich = sa > sb ? b : a;
        }
        AuthorMerger.enrichPidFromList(base, enrich, threshold);
        return base;
    }

    public static List<Author> mergeAuthor(List<Author> a, List<Author> b) {
        return AuthorMerger.mergeAuthor(a, b, THRESHOLD);
    }

    private static void enrichPidFromList(List<Author> base, List<Author> enrich, Double threshold) {
        if (base == null || enrich == null) {
            return;
        }
        Map<String, Author> basePidAuthorMap = base.stream().filter(a -> a.getPid() != null && !a.getPid().isEmpty()).flatMap(a -> a.getPid().stream().filter(Objects::nonNull).map(p -> new Tuple2((Object)AuthorMerger.pidToComparableString(p), a))).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2, (x1, x2) -> x1));
        List<Tuple2> pidToEnrich = enrich.stream().filter(a -> a.getPid() != null && !a.getPid().isEmpty()).flatMap(a -> a.getPid().stream().filter(Objects::nonNull).filter(p -> !basePidAuthorMap.containsKey(AuthorMerger.pidToComparableString(p))).map(p -> new Tuple2(p, a))).collect(Collectors.toList());
        pidToEnrich.forEach(a -> {
            Optional<Tuple2> simAuthor = base.stream().map(ba -> new Tuple2((Object)AuthorMerger.sim(ba, (Author)a._2()), ba)).max(Comparator.comparing(Tuple2::_1));
            if (simAuthor.isPresent()) {
                double th = threshold;
                if (((Author)simAuthor.get()._2()).getSurname() != null && ((Author)simAuthor.get()._2()).getSurname().length() <= 3 && threshold > 0.0) {
                    th = 0.99;
                }
                if ((Double)simAuthor.get()._1() > th) {
                    Author r = (Author)simAuthor.get()._2();
                    if (r.getPid() == null) {
                        r.setPid(new ArrayList());
                    }
                    ArrayList<Object> tmp = new ArrayList<Object>(r.getPid());
                    tmp.add(a._1());
                    r.setPid(tmp);
                }
            }
        });
    }

    public static String normalizeFullName(String fullname) {
        return AuthorMerger.nfd(fullname).toLowerCase().replaceAll("(\\W)+", " ").replaceAll("(\\p{InCombiningDiacriticalMarks})+", " ").replaceAll("(\\p{Punct})+", " ").replaceAll("(\\d)+", " ").replaceAll("(\\n)+", " ").trim();
    }

    private static String authorFieldToBeCompared(Author author) {
        if (StringUtils.isNotBlank((CharSequence)author.getSurname())) {
            return author.getSurname();
        }
        if (StringUtils.isNotBlank((CharSequence)author.getFullname())) {
            return author.getFullname();
        }
        return null;
    }

    public static String pidToComparableString(StructuredProperty pid) {
        String classId = Optional.ofNullable(pid).map(p -> Optional.ofNullable(p.getQualifier()).map(Qualifier::getClassid).map(String::toLowerCase).orElse("")).orElse("");
        return Optional.ofNullable(pid).map(StructuredProperty::getValue).map(v -> String.join((CharSequence)"|", v, classId)).orElse("");
    }

    public static int countAuthorsPids(List<Author> authors) {
        if (authors == null) {
            return 0;
        }
        return (int)authors.stream().filter(AuthorMerger::hasPid).count();
    }

    private static int authorsSize(List<Author> authors) {
        if (authors == null) {
            return 0;
        }
        return authors.size();
    }

    private static Double sim(Author a, Author b) {
        Person pa = AuthorMerger.parse(a);
        Person pb = AuthorMerger.parse(b);
        if (pa.isAccurate() & pb.isAccurate()) {
            return new JaroWinkler().score(AuthorMerger.normalize(pa.getSurnameString()), AuthorMerger.normalize(pb.getSurnameString())) * 0.5 + new JaroWinkler().score(AuthorMerger.normalize(pa.getNameString()), AuthorMerger.normalize(pb.getNameString())) * 0.5;
        }
        return new JaroWinkler().score(AuthorMerger.normalize(pa.getNormalisedFullname()), AuthorMerger.normalize(pb.getNormalisedFullname()));
    }

    private static boolean hasPid(Author a) {
        if (a == null || a.getPid() == null || a.getPid().isEmpty()) {
            return false;
        }
        return a.getPid().stream().anyMatch(p -> p != null && StringUtils.isNotBlank((CharSequence)p.getValue()));
    }

    private static Person parse(Author author) {
        if (StringUtils.isNotBlank((CharSequence)author.getSurname())) {
            return new Person(author.getSurname() + ", " + author.getName(), false);
        }
        if (StringUtils.isNotBlank((CharSequence)author.getFullname())) {
            return new Person(author.getFullname(), false);
        }
        return new Person("", false);
    }

    public static String normalize(String s) {
        Object[] normalized = AuthorMerger.nfd(s).toLowerCase().replaceAll("(\\W)+", " ").replaceAll("(\\p{InCombiningDiacriticalMarks})+", " ").replaceAll("(\\p{Punct})+", " ").replaceAll("(\\d)+", " ").replaceAll("(\\n)+", " ").trim().split(" ");
        Arrays.sort(normalized);
        return String.join((CharSequence)" ", (CharSequence[])normalized);
    }

    private static String nfd(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFD);
    }
}

