/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf.utils;

import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;

public class MergeComparator
implements Comparator<Oaf> {
    @Override
    public int compare(Oaf left, Oaf right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left.getDataInfo() != null && left.getDataInfo().getInvisible().booleanValue() && right.getDataInfo() != null && !right.getDataInfo().getInvisible().booleanValue()) {
            return -1;
        }
        HashSet<String> lCf = this.getCollectedFromIds(left);
        HashSet<String> rCf = this.getCollectedFromIds(right);
        if (lCf.contains("10|openaire____::081b82f96300b6a6e3d282bad31cb6e2") && !rCf.contains("10|openaire____::081b82f96300b6a6e3d282bad31cb6e2")) {
            return -1;
        }
        if (!lCf.contains("10|openaire____::081b82f96300b6a6e3d282bad31cb6e2") && rCf.contains("10|openaire____::081b82f96300b6a6e3d282bad31cb6e2")) {
            return 1;
        }
        SubEntityType lClass = SubEntityType.fromClass(left.getClass());
        SubEntityType rClass = SubEntityType.fromClass(right.getClass());
        return lClass.ordinal() - rClass.ordinal();
    }

    protected HashSet<String> getCollectedFromIds(Oaf left) {
        return Optional.ofNullable(left.getCollectedfrom()).map(cf -> cf.stream().map(KeyValue::getKey).collect(Collectors.toCollection(HashSet::new))).orElse(new HashSet());
    }

    static enum SubEntityType {
        publication,
        dataset,
        software,
        otherresearchproduct,
        datasource,
        organization,
        project;


        public static <T extends Oaf> SubEntityType fromClass(Class<T> clazz) {
            return SubEntityType.valueOf(clazz.getSimpleName().toLowerCase());
        }
    }
}

