/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf.utils;

import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class MergeEntitiesComparator
implements Comparator<Oaf> {
    static final List<String> PID_AUTHORITIES = Arrays.asList("10|opendoar____::6f4922f45568161a8cdf4ad2299f6d23", "10|opendoar____::eda80a3d5b344bc40f3bc04f65b7a357", "10|opendoar____::8b6dd7db9af49e67306feb59a8bdc52c", "10|openaire____::9e3be59865b2c1c335d32dae2fe7b254", "10|openaire____::081b82f96300b6a6e3d282bad31cb6e2");
    static final List<String> RESULT_TYPES = Arrays.asList("other", "software", "dataset", "publication");
    public static final Comparator<Oaf> INSTANCE = new MergeEntitiesComparator();

    @Override
    public int compare(Oaf left, Oaf right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        int res = 0;
        int cfp1 = Optional.ofNullable(left.getCollectedfrom()).map(cf -> cf.stream().map(kv -> PID_AUTHORITIES.indexOf(kv.getKey())).max(Integer::compare).orElse(-1)).orElse(-1);
        int cfp2 = Optional.ofNullable(right.getCollectedfrom()).map(cf -> cf.stream().map(kv -> PID_AUTHORITIES.indexOf(kv.getKey())).max(Integer::compare).orElse(-1)).orElse(-1);
        if (cfp1 >= 0 && cfp1 > cfp2) {
            return 1;
        }
        if (cfp2 >= 0 && cfp2 > cfp1) {
            return -1;
        }
        if (left.getDataInfo() != null && right.getDataInfo() != null) {
            res = left.getDataInfo().getTrust().compareTo(right.getDataInfo().getTrust());
        }
        if (res == 0 && left instanceof Result && right instanceof Result) {
            Result r1 = (Result)left;
            Result r2 = (Result)right;
            if (r1.getResulttype() == null || r1.getResulttype().getClassid() == null) {
                if (r2.getResulttype() != null && r2.getResulttype().getClassid() != null) {
                    return -1;
                }
            } else if (r2.getResulttype() == null || r2.getResulttype().getClassid() == null) {
                return 1;
            }
            int rt1 = RESULT_TYPES.indexOf(r1.getResulttype().getClassid());
            int rt2 = RESULT_TYPES.indexOf(r2.getResulttype().getClassid());
            if (rt1 >= 0 && rt1 > rt2) {
                return 1;
            }
            if (rt2 >= 0 && rt2 > rt1) {
                return -1;
            }
        }
        if (res == 0 && left instanceof OafEntity && right instanceof OafEntity) {
            res = ((OafEntity)right).getId().compareTo(((OafEntity)left).getId());
        }
        return res;
    }
}

