/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.index.es;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESFeeder
implements Closeable {
    private final ElasticsearchClient esClient;
    private final Logger logger = LoggerFactory.getLogger(ESFeeder.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public ESFeeder(String url) {
        RestClient client = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)url)}).setRequestConfigCallback(conf -> conf.setConnectTimeout(60000).setSocketTimeout(60000)).build();
        RestClientTransport transport = new RestClientTransport(client, (JsonpMapper)new JacksonJsonpMapper());
        this.esClient = new ElasticsearchClient((ElasticsearchTransport)transport);
    }

    private void tryBulk(ElasticsearchClient client, BulkRequest bulkRequest, int numberOfTry) {
        for (int i = 0; i < numberOfTry; ++i) {
            try {
                BulkResponse response = client.bulk(bulkRequest);
                if (!response.errors()) {
                    return;
                }
                this.logger.error("Bulk operation failed with errors!");
                this.logger.error(response.toString());
                continue;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private void indexRecords(Path file, FileSystem fileSystem, Function<String, BulkOperation> converter) {
        try (GZIPInputStream is = new GZIPInputStream((InputStream)fileSystem.open(file));
             BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            this.logger.info("Starting to index " + file.getName());
            BulkRequest.Builder br = new BulkRequest.Builder();
            ArrayList<BulkOperation> operations = new ArrayList<BulkOperation>();
            while ((line = reader.readLine()) != null) {
                operations.add(converter.apply(line));
                if (operations.size() != 1000) continue;
                br.operations(operations);
                this.tryBulk(this.getEsClient(), br.build(), 3);
                br = new BulkRequest.Builder();
                operations.clear();
            }
            if (!operations.isEmpty()) {
                br.operations(operations);
                this.tryBulk(this.getEsClient(), br.build(), 3);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void parallelBulkIndex(List<Path> files, int numberOfThreads, FileSystem fileSystem, Function<String, BulkOperation> converter) {
        ForkJoinPool customThreadPool = new ForkJoinPool(numberOfThreads);
        ((ForkJoinTask)customThreadPool.submit(() -> files.parallelStream().forEach(s -> this.indexRecords((Path)s, fileSystem, converter)))).join();
    }

    public void refreshIndex(String indexName) throws IOException {
        this.getEsClient().indices().refresh(i -> i.index(indexName, new String[0]));
    }

    @Override
    public void close() throws IOException {
        this.getEsClient().close();
    }

    public ElasticsearchClient getEsClient() {
        return this.esClient;
    }
}

