/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.common.DbClient;
import eu.dnetlib.dhp.common.action.model.MasterDuplicate;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadDatasourceMasterDuplicateFromDB {
    private static final Logger log = LoggerFactory.getLogger(ReadDatasourceMasterDuplicateFromDB.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String QUERY = "SELECT distinct dd.id as masterId, d.officialname as masterName, dd.duplicate as duplicateId FROM dsm_dedup_services dd join dsm_services d on (dd.id = d.id);";

    public static int execute(String dbUrl, String dbUser, String dbPassword, String hdfsPath, String hdfsNameNode) throws IOException {
        int count = 0;
        try (DbClient dbClient = new DbClient(dbUrl, dbUser, dbPassword);){
            Configuration conf = DHPUtils.getHadoopConfiguration(hdfsNameNode);
            Path p = new Path(hdfsPath);
            FileSystem fileSystem = p.getFileSystem(conf);
            FSDataOutputStream fos = fileSystem.create(p);
            log.info("running query: {}", (Object)QUERY);
            log.info("storing results in: {}", (Object)hdfsPath);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));){
                dbClient.processResults(QUERY, rs -> ReadDatasourceMasterDuplicateFromDB.writeMap(ReadDatasourceMasterDuplicateFromDB.datasourceMasterMap(rs), writer));
            }
        }
        return ++count;
    }

    private static MasterDuplicate datasourceMasterMap(ResultSet rs) {
        try {
            MasterDuplicate md = new MasterDuplicate();
            String duplicateId = rs.getString("duplicateId");
            String masterId = rs.getString("masterId");
            String masterName = rs.getString("masterName");
            md.setDuplicateId(OafMapperUtils.createOpenaireId(10, duplicateId, true));
            md.setMasterId(OafMapperUtils.createOpenaireId(10, masterId, true));
            md.setMasterName(masterName);
            return md;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeMap(MasterDuplicate dm, BufferedWriter writer) {
        try {
            writer.write(OBJECT_MAPPER.writeValueAsString((Object)dm));
            writer.newLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

