/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.utils.saxon;

import eu.dnetlib.dhp.utils.saxon.AbstractExtensionFunction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.apache.commons.lang3.StringUtils;

public class NormalizeDate
extends AbstractExtensionFunction {
    private static final String[] normalizeDateFormats = new String[]{"yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy"};
    private static final String normalizeOutFormat = "yyyy-MM-dd'T'hh:mm:ss'Z'";
    public static final String BLANK = "";

    @Override
    public String getName() {
        return "normalizeDate";
    }

    @Override
    public Sequence doCall(XPathContext context, Sequence[] arguments) throws XPathException {
        if (arguments == null || arguments.length == 0) {
            return new StringValue((CharSequence)BLANK);
        }
        String s = arguments[0].head().getStringValue();
        return new StringValue((CharSequence)this._normalizeDate(s));
    }

    public int getMinimumNumberOfArguments() {
        return 0;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_ITEM};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    private String _normalizeDate(String s) {
        String date = StringUtils.isNotBlank((CharSequence)s) ? s.trim() : BLANK;
        for (String format : normalizeDateFormats) {
            try {
                Date parse = new SimpleDateFormat(format).parse(date);
                String res = new SimpleDateFormat(normalizeOutFormat).format(parse);
                return res;
            }
            catch (ParseException parseException) {
            }
        }
        return BLANK;
    }
}

