/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.common.api;

import com.google.gson.Gson;
import eu.dnetlib.dhp.common.api.MissingConceptDoiException;
import eu.dnetlib.dhp.common.api.zenodo.ZenodoModel;
import eu.dnetlib.dhp.common.api.zenodo.ZenodoModelList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;

public class ZenodoAPIClient
implements Serializable {
    String urlString;
    String bucket;
    String deposition_id;
    String access_token;
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType MEDIA_TYPE_ZIP = MediaType.parse((String)"application/zip");

    public String getUrlString() {
        return this.urlString;
    }

    public void setUrlString(String urlString) {
        this.urlString = urlString;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setDeposition_id(String deposition_id) {
        this.deposition_id = deposition_id;
    }

    public ZenodoAPIClient(String urlString, String access_token) {
        this.urlString = urlString;
        this.access_token = access_token;
    }

    public int newDeposition() throws IOException {
        String json = "{}";
        URL url = new URL(this.urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Content-Type", ContentType.APPLICATION_JSON.toString());
        conn.setRequestProperty("Authorization", "Bearer " + this.access_token);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        try (OutputStream os = conn.getOutputStream();){
            byte[] input = json.getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        String body = this.getBody(conn);
        int responseCode = conn.getResponseCode();
        conn.disconnect();
        if (!this.checkOKStatus(responseCode)) {
            throw new IOException("Unexpected code " + responseCode + body);
        }
        ZenodoModel newSubmission = (ZenodoModel)new Gson().fromJson(body, ZenodoModel.class);
        this.bucket = newSubmission.getLinks().getBucket();
        this.deposition_id = newSubmission.getId();
        return responseCode;
    }

    public int uploadIS(InputStream is, String file_name) throws IOException {
        URL url = new URL(this.bucket + "/" + file_name);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Content-Type", "application/zip");
        conn.setRequestProperty("Authorization", "Bearer " + this.access_token);
        conn.setDoOutput(true);
        conn.setRequestMethod("PUT");
        byte[] buf = new byte[8192];
        try (OutputStream os = conn.getOutputStream();){
            int length;
            while ((length = is.read(buf)) != -1) {
                os.write(buf, 0, length);
            }
        }
        int responseCode = conn.getResponseCode();
        if (!this.checkOKStatus(responseCode)) {
            throw new IOException("Unexpected code " + responseCode + this.getBody(conn));
        }
        return responseCode;
    }

    @NotNull
    private String getBody(HttpURLConnection conn) throws IOException {
        String body = "{}";
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));){
            StringBuilder response = new StringBuilder();
            String responseLine = null;
            while ((responseLine = br.readLine()) != null) {
                response.append(responseLine.trim());
            }
            body = response.toString();
        }
        return body;
    }

    public int sendMretadata(String metadata) throws IOException {
        URL url = new URL(this.urlString + "/" + this.deposition_id);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Content-Type", ContentType.APPLICATION_JSON.toString());
        conn.setRequestProperty("Authorization", "Bearer " + this.access_token);
        conn.setDoOutput(true);
        conn.setRequestMethod("PUT");
        try (OutputStream os = conn.getOutputStream();){
            byte[] input = metadata.getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        int responseCode = conn.getResponseCode();
        conn.disconnect();
        if (!this.checkOKStatus(responseCode)) {
            throw new IOException("Unexpected code " + responseCode + this.getBody(conn));
        }
        return responseCode;
    }

    private boolean checkOKStatus(int responseCode) {
        return 200 != responseCode || 201 != responseCode;
    }

    @Deprecated
    public int publish() throws IOException {
        String json = "{}";
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(600L, TimeUnit.SECONDS).build();
        RequestBody body = RequestBody.create((String)json, (MediaType)MEDIA_TYPE_JSON);
        Request request = new Request.Builder().url(this.urlString + "/" + this.deposition_id + "/actions/publish").addHeader("Authorization", "Bearer " + this.access_token).post(body).build();
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + String.valueOf(response) + response.body().string());
            }
            int n = response.code();
            return n;
        }
    }

    public int newVersion(String concept_rec_id) throws IOException, MissingConceptDoiException {
        this.setDepositionId(concept_rec_id, 1);
        String json = "{}";
        URL url = new URL(this.urlString + "/" + this.deposition_id + "/actions/newversion");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Authorization", "Bearer " + this.access_token);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        try (OutputStream os = conn.getOutputStream();){
            byte[] input = json.getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        String body = this.getBody(conn);
        int responseCode = conn.getResponseCode();
        conn.disconnect();
        if (!this.checkOKStatus(responseCode)) {
            throw new IOException("Unexpected code " + responseCode + body);
        }
        ZenodoModel zenodoModel = (ZenodoModel)new Gson().fromJson(body, ZenodoModel.class);
        String latest_draft = zenodoModel.getLinks().getLatest_draft();
        this.deposition_id = latest_draft.substring(latest_draft.lastIndexOf("/") + 1);
        this.bucket = this.getBucket(latest_draft);
        return responseCode;
    }

    public int uploadOpenDeposition(String deposition_id) throws IOException {
        this.deposition_id = deposition_id;
        String json = "{}";
        URL url = new URL(this.urlString + "/" + deposition_id);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Authorization", "Bearer " + this.access_token);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        try (OutputStream os = conn.getOutputStream();){
            byte[] input = json.getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        String body = this.getBody(conn);
        int responseCode = conn.getResponseCode();
        conn.disconnect();
        if (!this.checkOKStatus(responseCode)) {
            throw new IOException("Unexpected code " + responseCode + body);
        }
        ZenodoModel zenodoModel = (ZenodoModel)new Gson().fromJson(body, ZenodoModel.class);
        this.bucket = zenodoModel.getLinks().getBucket();
        return responseCode;
    }

    private void setDepositionId(String concept_rec_id, Integer page) throws IOException, MissingConceptDoiException {
        ZenodoModelList zenodoModelList = (ZenodoModelList)new Gson().fromJson(this.getPrevDepositions(String.valueOf(page)), ZenodoModelList.class);
        for (ZenodoModel zm : zenodoModelList) {
            if (!zm.getConceptrecid().equals(concept_rec_id)) continue;
            this.deposition_id = zm.getId();
            return;
        }
        if (zenodoModelList.size() == 0) {
            throw new MissingConceptDoiException("The concept record id specified was missing in the list of depositions");
        }
        this.setDepositionId(concept_rec_id, page + 1);
    }

    private String getPrevDepositions(String page) throws IOException {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.urlString).newBuilder();
        urlBuilder.addQueryParameter("page", page);
        URL url = new URL(urlBuilder.build().toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Content-Type", ContentType.APPLICATION_JSON.toString());
        conn.setRequestProperty("Authorization", "Bearer " + this.access_token);
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        String body = this.getBody(conn);
        int responseCode = conn.getResponseCode();
        conn.disconnect();
        if (!this.checkOKStatus(responseCode)) {
            throw new IOException("Unexpected code " + responseCode + body);
        }
        return body;
    }

    private String getBucket(String inputUurl) throws IOException {
        URL url = new URL(inputUurl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Content-Type", ContentType.APPLICATION_JSON.toString());
        conn.setRequestProperty("Authorization", "Bearer " + this.access_token);
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        String body = this.getBody(conn);
        int responseCode = conn.getResponseCode();
        conn.disconnect();
        if (!this.checkOKStatus(responseCode)) {
            throw new IOException("Unexpected code " + responseCode + body);
        }
        ZenodoModel zenodoModel = (ZenodoModel)new Gson().fromJson(body, ZenodoModel.class);
        return zenodoModel.getLinks().getBucket();
    }
}

