/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oozie;

import com.google.common.io.Resources;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunSQLSparkJob {
    private static final Logger log = LoggerFactory.getLogger(RunSQLSparkJob.class);
    private final ArgumentApplicationParser parser;

    public RunSQLSparkJob(ArgumentApplicationParser parser) {
        this.parser = parser;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].startsWith("--")) continue;
            params.put(args[i].substring(2), args[++i]);
        }
        Boolean isSparkSessionManaged = Optional.ofNullable((String)params.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String raw_sql = (String)params.get("sql");
        try {
            URL url = Resources.getResource((String)((String)params.get("sql")));
            raw_sql = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sql = StringSubstitutor.replace((Object)raw_sql, params);
        log.info("sql: {}", (Object)sql);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", (String)params.get("hiveMetastoreUris"));
        SparkSessionSupport.runWithSparkHiveSession(conf, isSparkSessionManaged, spark -> {
            for (String statement : sql.split(";\\s*/\\*\\s*EOS\\s*\\*/\\s*")) {
                log.info("executing: {}", (Object)statement);
                long startTime = System.currentTimeMillis();
                try {
                    spark.sql(statement).show();
                }
                catch (Exception e) {
                    log.error("Error executing statement: {}", (Object)statement, (Object)e);
                    System.err.println("Error executing statement: " + statement + "\n" + String.valueOf(e));
                    throw e;
                }
                log.info("executed in {}", (Object)DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - startTime), (String)"HH:mm:ss.S"));
            }
        });
    }
}

