/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.message;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.message.Message;
import eu.dnetlib.dhp.message.MessageType;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSender {
    private static final Logger log = LoggerFactory.getLogger(MessageSender.class);
    private static final int SOCKET_TIMEOUT_MS = 2000;
    private static final int CONNECTION_REQUEST_TIMEOUT_MS = 2000;
    private static final int CONNTECTION_TIMEOUT_MS = 2000;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String dnetMessageEndpoint;
    private final String workflowId;
    private final ExecutorService executorService = Executors.newCachedThreadPool();

    public MessageSender(String dnetMessageEndpoint, String workflowId) {
        this.workflowId = workflowId;
        this.dnetMessageEndpoint = dnetMessageEndpoint;
    }

    public void sendMessage(Message message) {
        this.executorService.submit(() -> this._sendMessage(message));
    }

    public void sendMessage(Long current, Long total) {
        this.sendMessage(this.createOngoingMessage(current, total));
    }

    public void sendReport(Map<String, String> report) {
        this.sendMessage(new Message(MessageType.REPORT, this.workflowId, report));
    }

    private Message createOngoingMessage(Long current, Long total) {
        Message m = new Message(MessageType.ONGOING, this.workflowId);
        m.getBody().put("current", current.toString());
        if (total != null) {
            m.getBody().put("total", total.toString());
        }
        return m;
    }

    private void _sendMessage(Message message) {
        try {
            String json = this.objectMapper.writeValueAsString((Object)message);
            HttpPut req = new HttpPut(this.dnetMessageEndpoint);
            req.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setConnectionRequestTimeout(2000).setSocketTimeout(2000).build();
            try (CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
                 CloseableHttpResponse response = client.execute((HttpUriRequest)req);){
                log.debug("Sent Message to " + this.dnetMessageEndpoint);
                log.debug("MESSAGE:" + String.valueOf(message));
            }
            catch (Throwable e) {
                log.error("Error sending message to " + this.dnetMessageEndpoint + ", message content: " + String.valueOf(message), e);
            }
        }
        catch (JsonProcessingException e) {
            log.error("Error sending message to " + this.dnetMessageEndpoint + ", message content: " + String.valueOf(message), (Throwable)e);
        }
    }
}

