/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.PidBlacklist;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class PidBlacklistProvider {
    private static final PidBlacklist blacklist;

    public static PidBlacklist getBlacklist() {
        return blacklist;
    }

    public static Set<String> getBlacklist(String pidType) {
        return Optional.ofNullable((HashSet)PidBlacklistProvider.getBlacklist().get(pidType)).orElse(new HashSet());
    }

    private PidBlacklistProvider() {
    }

    static {
        try {
            String json = IOUtils.toString((InputStream)IdentifierFactory.class.getResourceAsStream("pid_blacklist.json"));
            blacklist = (PidBlacklist)new ObjectMapper().readValue(json, PidBlacklist.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

