/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.AbstractSparkAction;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.oa.dedup.Deduper;
import eu.dnetlib.dhp.oa.dedup.model.Block;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.FieldValueImpl;
import eu.dnetlib.pace.model.MapDocument;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkCreateSimRels
extends AbstractSparkAction {
    private static final Logger log = LoggerFactory.getLogger(SparkCreateSimRels.class);

    public SparkCreateSimRels(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCreateSimRels.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/createSimRels_parameters.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.registerKryoClasses(new Class[]{MapDocument.class, FieldListImpl.class, FieldValueImpl.class, Block.class});
        new SparkCreateSimRels(parser, SparkCreateSimRels.getSparkSession(conf)).run(ISLookupClientFactory.getLookUpService((String)parser.get("isLookUpUrl")));
    }

    @Override
    public void run(ISLookUpService isLookUpService) throws DocumentException, IOException, ISLookUpException {
        String graphBasePath = this.parser.get("graphBasePath");
        String isLookUpUrl = this.parser.get("isLookUpUrl");
        String actionSetId = this.parser.get("actionSetId");
        String workingPath = this.parser.get("workingPath");
        log.info("graphBasePath: '{}'", (Object)graphBasePath);
        log.info("isLookUpUrl:   '{}'", (Object)isLookUpUrl);
        log.info("actionSetId:   '{}'", (Object)actionSetId);
        log.info("workingPath:   '{}'", (Object)workingPath);
        for (DedupConfig dedupConf : this.getConfigurations(isLookUpService, actionSetId)) {
            String entity = dedupConf.getWf().getEntityType();
            String subEntity = dedupConf.getWf().getSubEntityValue();
            log.info("Creating simrels for: '{}'", (Object)subEntity);
            String outputPath = DedupUtility.createSimRelPath(workingPath, actionSetId, subEntity);
            SparkCreateSimRels.removeOutputDir(this.spark, outputPath);
            JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)this.spark.sparkContext());
            JavaPairRDD mapDocuments = sc.textFile(DedupUtility.createEntityPath(graphBasePath, subEntity)).mapToPair((PairFunction & Serializable)s -> {
                MapDocument d = MapDocumentUtil.asMapDocumentWithJPath((DedupConfig)dedupConf, (String)s);
                return new Tuple2((Object)d.getIdentifier(), (Object)d);
            });
            JavaPairRDD<String, Block> blocks = Deduper.createSortedBlocks((JavaPairRDD<String, MapDocument>)mapDocuments, dedupConf);
            JavaRDD relations = Deduper.computeRelations(sc, blocks, dedupConf).map((Function & Serializable)t -> this.createSimRel((String)t._1(), (String)t._2(), entity));
            this.spark.createDataset(relations.rdd(), Encoders.bean(Relation.class)).write().mode(SaveMode.Append).save(outputPath);
        }
    }

    private Relation createSimRel(String source, String target, String entity) {
        Relation r = new Relation();
        r.setSource(source);
        r.setTarget(target);
        r.setSubRelType("dedupSimilarity");
        r.setRelClass("isSimilarTo");
        r.setDataInfo(new DataInfo());
        switch (entity) {
            case "result": {
                r.setRelType("resultResult");
                break;
            }
            case "organization": {
                r.setRelType("organizationOrganization");
                break;
            }
            default: {
                throw new IllegalArgumentException("unmanaged entity type: " + entity);
            }
        }
        return r;
    }
}

