/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.SparkBlockStats;
import eu.dnetlib.dhp.oa.dedup.SparkDedupTest;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class SparkStatsTest
implements Serializable {
    @Mock(serializable=true)
    ISLookUpService isLookUpService;
    private static SparkSession spark;
    private static JavaSparkContext jsc;
    private static String testGraphBasePath;
    private static String testOutputBasePath;
    private static final String testActionSetId = "test-orchestrator";

    @BeforeAll
    public static void beforeAll() throws IOException, URISyntaxException {
        testGraphBasePath = Paths.get(SparkDedupTest.class.getResource("/eu/dnetlib/dhp/dedup/entities").toURI()).toFile().getAbsolutePath();
        testOutputBasePath = Files.createTempDirectory(SparkDedupTest.class.getSimpleName() + "-", new FileAttribute[0]).toAbsolutePath().toString();
        FileUtils.deleteDirectory((File)new File(testOutputBasePath));
        SparkConf conf = new SparkConf();
        conf.set("spark.sql.shuffle.partitions", "200");
        spark = SparkSession.builder().appName(SparkDedupTest.class.getSimpleName()).master("local[*]").config(conf).getOrCreate();
        jsc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
    }

    @BeforeEach
    public void setUp() throws IOException, ISLookUpException {
        Mockito.lenient().when((Object)this.isLookUpService.getResourceProfileByQuery(Mockito.contains((String)testActionSetId))).thenReturn((Object)IOUtils.toString((InputStream)SparkStatsTest.class.getResourceAsStream("/eu/dnetlib/dhp/dedup/profiles/mock_orchestrator.xml")));
        Mockito.lenient().when((Object)this.isLookUpService.getResourceProfileByQuery(Mockito.contains((String)"organization"))).thenReturn((Object)IOUtils.toString((InputStream)SparkStatsTest.class.getResourceAsStream("/eu/dnetlib/dhp/dedup/conf/org.curr.conf.json")));
        Mockito.lenient().when((Object)this.isLookUpService.getResourceProfileByQuery(Mockito.contains((String)"publication"))).thenReturn((Object)IOUtils.toString((InputStream)SparkStatsTest.class.getResourceAsStream("/eu/dnetlib/dhp/dedup/conf/pub.curr.conf.json")));
        Mockito.lenient().when((Object)this.isLookUpService.getResourceProfileByQuery(Mockito.contains((String)"software"))).thenReturn((Object)IOUtils.toString((InputStream)SparkStatsTest.class.getResourceAsStream("/eu/dnetlib/dhp/dedup/conf/sw.curr.conf.json")));
        Mockito.lenient().when((Object)this.isLookUpService.getResourceProfileByQuery(Mockito.contains((String)"dataset"))).thenReturn((Object)IOUtils.toString((InputStream)SparkStatsTest.class.getResourceAsStream("/eu/dnetlib/dhp/dedup/conf/ds.curr.conf.json")));
        Mockito.lenient().when((Object)this.isLookUpService.getResourceProfileByQuery(Mockito.contains((String)"otherresearchproduct"))).thenReturn((Object)IOUtils.toString((InputStream)SparkStatsTest.class.getResourceAsStream("/eu/dnetlib/dhp/dedup/conf/orp.curr.conf.json")));
    }

    @Test
    void createBlockStatsTest() throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkStatsTest.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/createBlockStats_parameters.json")));
        parser.parseArgument(new String[]{"-i", testGraphBasePath, "-asi", testActionSetId, "-la", "lookupurl", "-w", testOutputBasePath});
        new SparkBlockStats(parser, spark).run(this.isLookUpService);
        long orgs_blocks = spark.read().load(testOutputBasePath + "/" + testActionSetId + "/organization_blockstats").count();
        long pubs_blocks = spark.read().load(testOutputBasePath + "/" + testActionSetId + "/publication_blockstats").count();
        long sw_blocks = spark.read().load(testOutputBasePath + "/" + testActionSetId + "/software_blockstats").count();
        long ds_blocks = spark.read().load(testOutputBasePath + "/" + testActionSetId + "/dataset_blockstats").count();
        long orp_blocks = spark.read().load(testOutputBasePath + "/" + testActionSetId + "/otherresearchproduct_blockstats").count();
        Assertions.assertEquals((long)406L, (long)orgs_blocks);
        Assertions.assertEquals((long)221L, (long)pubs_blocks);
        Assertions.assertEquals((long)134L, (long)sw_blocks);
        Assertions.assertEquals((long)196L, (long)ds_blocks);
        Assertions.assertEquals((long)198L, (long)orp_blocks);
    }

    @AfterAll
    public static void tearDown() {
        spark.close();
    }
}

