/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.application.dedup.log.DedupLogModel;
import eu.dnetlib.dhp.application.dedup.log.DedupLogWriter;
import eu.dnetlib.dhp.oa.dedup.AbstractSparkAction;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.SparkDeduper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SparkCreateSimRels
extends AbstractSparkAction {
    private static final Logger log = LoggerFactory.getLogger(SparkCreateSimRels.class);

    public SparkCreateSimRels(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
        spark.sparkContext().setLogLevel("WARN");
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCreateSimRels.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/createSimRels_parameters.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        try (SparkSession session = SparkCreateSimRels.getSparkSession(conf);){
            new SparkCreateSimRels(parser, session).run(ISLookupClientFactory.getLookUpService((String)parser.get("isLookUpUrl")));
        }
    }

    @Override
    public void run(ISLookUpService isLookUpService) throws DocumentException, IOException, ISLookUpException, SAXException {
        String graphBasePath = this.parser.get("graphBasePath");
        String isLookUpUrl = this.parser.get("isLookUpUrl");
        String actionSetId = this.parser.get("actionSetId");
        String workingPath = this.parser.get("workingPath");
        int numPartitions = Optional.ofNullable(this.parser.get("numPartitions")).map(Integer::valueOf).orElse(1000);
        log.info("numPartitions: '{}'", (Object)numPartitions);
        log.info("graphBasePath: '{}'", (Object)graphBasePath);
        log.info("isLookUpUrl:   '{}'", (Object)isLookUpUrl);
        log.info("actionSetId:   '{}'", (Object)actionSetId);
        log.info("workingPath:   '{}'", (Object)workingPath);
        String dfLogPath = this.parser.get("dataframeLog");
        String runTag = Optional.ofNullable(this.parser.get("runTAG")).orElse("UNKNOWN");
        for (DedupConfig dedupConf : this.getConfigurations(isLookUpService, actionSetId)) {
            long start = System.currentTimeMillis();
            String entity = dedupConf.getWf().getEntityType();
            String subEntity = dedupConf.getWf().getSubEntityValue();
            log.info("Creating simrels for: '{}'", (Object)subEntity);
            String modelPath = DedupUtility.createModelPath(workingPath, actionSetId, subEntity);
            String outputPath = DedupUtility.createSimRelPath(workingPath, actionSetId, subEntity);
            SparkCreateSimRels.removeOutputDir(this.spark, outputPath);
            SparkDeduper deduper = new SparkDeduper(dedupConf);
            this.spark.read().textFile(DedupUtility.createEntityPath(graphBasePath, subEntity)).transform(deduper.model().parseJsonDataset()).write().option("compression", "gzip").mode("overwrite").parquet(modelPath);
            Dataset simRels = this.spark.read().parquet(modelPath).transform(deduper.dedup()).distinct().map((MapFunction & Serializable)t -> DedupUtility.createSimRel(t.getStruct(0).getString(0), t.getStruct(0).getString(1), entity), Encoders.bean(Relation.class));
            SparkCreateSimRels.saveParquet(simRels, outputPath, SaveMode.Overwrite);
            long end = System.currentTimeMillis();
            if (!StringUtils.isNotBlank((CharSequence)dfLogPath)) continue;
            DedupLogModel model = new DedupLogModel(runTag, dedupConf.toString(), subEntity, start, end, end - start);
            new DedupLogWriter(dfLogPath).appendLog(model, this.spark);
        }
    }
}

