/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup.model;

import eu.dnetlib.dhp.oa.dedup.DatePicker;
import eu.dnetlib.dhp.oa.dedup.IdentifierComparator;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Identifier<T extends OafEntity>
implements Serializable,
Comparable<Identifier<T>> {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String BASE_DATE = "2000-01-01";
    private T entity;
    private Date date = null;

    public static <T extends OafEntity> Identifier<T> newInstance(T entity) {
        return new Identifier<T>(entity);
    }

    public Identifier(T entity) {
        this.entity = entity;
    }

    public T getEntity() {
        return this.entity;
    }

    public void setEntity(T entity) {
        this.entity = entity;
    }

    public Date getDate() {
        Result result;
        if (Objects.nonNull(this.date)) {
            return this.date;
        }
        String sDate = LocalDate.now().plusDays(1L).toString();
        if (ModelSupport.isSubClass(this.getEntity(), Result.class).booleanValue() && Identifier.isWellformed((Field<String>)(result = (Result)this.getEntity()).getDateofacceptance())) {
            sDate = (String)result.getDateofacceptance().getValue();
        }
        try {
            this.date = new SimpleDateFormat(DATE_FORMAT).parse(sDate);
            return this.date;
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("cannot parse date: '%s' from record: '%s'", sDate, this.entity.getId()));
        }
    }

    private static boolean isWellformed(Field<String> date) {
        return date != null && StringUtils.isNotBlank((CharSequence)((CharSequence)date.getValue())) && ((String)date.getValue()).matches("^(\\d{4})-(\\d{2})-(\\d{2})") && DatePicker.inRange((String)date.getValue());
    }

    public List<KeyValue> getCollectedFrom() {
        return this.entity.getCollectedfrom();
    }

    public EntityType getEntityType() {
        return EntityType.fromClass(this.entity.getClass());
    }

    public String getOriginalID() {
        return this.entity.getId();
    }

    public PidType getPidType() {
        return PidType.tryValueOf((String)StringUtils.substringBefore((String)StringUtils.substringAfter((String)this.entity.getId(), (String)"|"), (String)"_"));
    }

    @Override
    public int compareTo(Identifier<T> i) {
        return IdentifierComparator.compareIdentifiers(this, i);
    }
}

