/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.AbstractSparkAction;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkCopyOpenorgsSimRels
extends AbstractSparkAction {
    private static final Logger log = LoggerFactory.getLogger(SparkCopyOpenorgsSimRels.class);

    public SparkCopyOpenorgsSimRels(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCopyOpenorgsSimRels.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/copyOpenorgsMergeRels_parameters.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        new SparkCopyOpenorgsSimRels(parser, SparkCopyOpenorgsSimRels.getSparkSession(conf)).run(ISLookupClientFactory.getLookUpService((String)parser.get("isLookUpUrl")));
    }

    @Override
    public void run(ISLookUpService isLookUpService) throws DocumentException, IOException, ISLookUpException {
        String graphBasePath = this.parser.get("graphBasePath");
        String actionSetId = this.parser.get("actionSetId");
        String workingPath = this.parser.get("workingPath");
        int numPartitions = Optional.ofNullable(this.parser.get("numPartitions")).map(Integer::valueOf).orElse(1000);
        log.info("numPartitions: '{}'", (Object)numPartitions);
        log.info("graphBasePath: '{}'", (Object)graphBasePath);
        log.info("actionSetId:   '{}'", (Object)actionSetId);
        log.info("workingPath:   '{}'", (Object)workingPath);
        log.info("Copying OpenOrgs SimRels");
        String outputPath = DedupUtility.createSimRelPath(workingPath, actionSetId, "organization");
        String relationPath = DedupUtility.createEntityPath(graphBasePath, "relation");
        Dataset rawRels = this.spark.read().schema(Encoders.bean(Relation.class).schema()).json(relationPath).as(Encoders.bean(Relation.class)).map(SparkCopyOpenorgsSimRels.patchRelFn(), Encoders.bean(Relation.class)).filter(this::filterOpenorgsRels);
        SparkCopyOpenorgsSimRels.saveParquet(rawRels, outputPath, SaveMode.Append);
        log.info("Copied {} Similarity Relations", (Object)rawRels.count());
    }

    private boolean filterOpenorgsRels(Relation rel) {
        return rel.getRelClass().equals("isSimilarTo") && rel.getRelType().equals("organizationOrganization") && rel.getSubRelType().equals("dedup") && this.isOpenorgs(rel);
    }
}

