/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.oa.dedup.SparkDedupTest;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.utils.MergeUtils;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Tuple2;

class DatasetMergerTest
implements Serializable {
    private List<Tuple2<String, Dataset>> datasets;
    private String testEntityBasePath;
    private DataInfo dataInfo;
    private final String dedupId = "50|doi_________::3d18564ef27ebe9ef3bd8b4dec67e148";
    private Dataset dataset_top;

    DatasetMergerTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testEntityBasePath = Paths.get(SparkDedupTest.class.getResource("/eu/dnetlib/dhp/dedup/json").toURI()).toFile().getAbsolutePath();
        this.datasets = this.readSample(this.testEntityBasePath + "/dataset_merge.json", Dataset.class);
        this.dataset_top = this.getTopPub(this.datasets);
        this.dataInfo = this.setDI();
    }

    @Test
    void datasetMergerTest() {
        Dataset pub_merged = (Dataset)MergeUtils.mergeGroup(this.datasets.stream().map(Tuple2::_2).iterator());
        Assertions.assertEquals((Object)"50|doi_________::3d18564ef27ebe9ef3bd8b4dec67e148", (Object)pub_merged.getId());
        Assertions.assertEquals((int)2, (int)pub_merged.getInstance().size());
    }

    public DataInfo setDI() {
        DataInfo dataInfo = new DataInfo();
        dataInfo.setTrust("0.9");
        dataInfo.setDeletedbyinference(Boolean.valueOf(false));
        dataInfo.setInferenceprovenance("testing");
        dataInfo.setInferred(Boolean.valueOf(true));
        return dataInfo;
    }

    public Dataset getTopPub(List<Tuple2<String, Dataset>> publications) {
        Double maxTrust = 0.0;
        Dataset maxPub = new Dataset();
        for (Tuple2<String, Dataset> publication : publications) {
            Double pubTrust = Double.parseDouble(((Dataset)publication._2()).getDataInfo().getTrust());
            if (!(pubTrust > maxTrust)) continue;
            maxTrust = pubTrust;
            maxPub = (Dataset)publication._2();
        }
        return maxPub;
    }

    public <T> List<Tuple2<String, T>> readSample(String path, Class<T> clazz) {
        ArrayList<Tuple2<String, T>> res = new ArrayList<Tuple2<String, T>>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(path));
            String line = reader.readLine();
            while (line != null) {
                res.add(new Tuple2((Object)MapDocumentUtil.getJPathString((String)"$.id", (String)line), new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(line, clazz)));
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }
}

