/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import eu.dnetlib.dhp.oa.dedup.IdGenerator;
import eu.dnetlib.dhp.oa.dedup.SparkDedupTest;
import eu.dnetlib.dhp.oa.dedup.model.Identifier;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.pace.util.MapDocumentUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import scala.Tuple2;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class IdGeneratorTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static List<Identifier<Publication>> bestIds;
    private static List<Identifier<Publication>> bestIds2;
    private static List<Identifier<Publication>> bestIds3;
    private static List<Identifier<Organization>> bestIdsOrg;
    private static String testEntityBasePath;

    @BeforeAll
    public static void setUp() throws Exception {
        testEntityBasePath = Paths.get(SparkDedupTest.class.getResource("/eu/dnetlib/dhp/dedup/json").toURI()).toFile().getAbsolutePath();
        bestIds = IdGeneratorTest.createBestIds(testEntityBasePath + "/publication_idgeneration.json", Publication.class);
        bestIds2 = IdGeneratorTest.createBestIds(testEntityBasePath + "/publication_idgeneration2.json", Publication.class);
        bestIds3 = IdGeneratorTest.createBestIds(testEntityBasePath + "/publication_idgeneration3.json", Publication.class);
        bestIdsOrg = IdGeneratorTest.createBestIds(testEntityBasePath + "/organization_idgeneration.json", Organization.class);
    }

    @Test
    void generateIdTest1() {
        String id1 = IdGenerator.generate(bestIds, (String)"50|defaultID");
        System.out.println("id list 1 = " + bestIds.stream().map(i -> i.getOriginalID()).collect(Collectors.toList()));
        Assertions.assertEquals((Object)"50|doi_dedup___::0968af610a356656706657e4f234b340", (Object)id1);
    }

    @Test
    void generateIdTest2() {
        String id1 = IdGenerator.generate(bestIds2, (String)"50|defaultID");
        String id2 = IdGenerator.generate(bestIds3, (String)"50|defaultID");
        System.out.println("id list 2 = " + bestIds2.stream().map(i -> i.getOriginalID()).collect(Collectors.toList()));
        System.out.println("winner 2 = " + id1);
        System.out.println("id list 3 = " + bestIds3.stream().map(i -> i.getOriginalID()).collect(Collectors.toList()));
        System.out.println("winner 3 = " + id2);
        Assertions.assertEquals((Object)"50|doi_dedup___::1a77a3bba737f8b669dcf330ad3b37e2", (Object)id1);
        Assertions.assertEquals((Object)"50|dedup_wf_002::345e5d1b80537b0d0e0a49241ae9e516", (Object)id2);
    }

    @Test
    void generateIdOrganizationTest() {
        String id1 = IdGenerator.generate(bestIdsOrg, (String)"20|defaultID");
        Assertions.assertEquals((Object)"20|openorgs____::599c15a70fcb03be6ba08f75f14d6076", (Object)id1);
    }

    protected static <T extends OafEntity> List<Identifier<T>> createBestIds(String path, Class<T> clazz) {
        Stream<Identifier> ids = IdGeneratorTest.readSample(path, clazz).stream().map(Tuple2::_2).map(Identifier::newInstance);
        return ids.collect(Collectors.toList());
    }

    public static <T> List<Tuple2<String, T>> readSample(String path, Class<T> clazz) {
        ArrayList<Tuple2<String, T>> res = new ArrayList<Tuple2<String, T>>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(path));
            String line = reader.readLine();
            while (line != null) {
                res.add(new Tuple2((Object)MapDocumentUtil.getJPathString((String)"$.id", (String)line), OBJECT_MAPPER.readValue(line, clazz)));
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static StructuredProperty pid(String pid, String classid, String classname) {
        return OafMapperUtils.structuredProperty((String)pid, (String)classid, (String)classname, (String)"", (String)"", (DataInfo)new DataInfo());
    }

    public static List<KeyValue> keyValue(String key, String value) {
        return Lists.newArrayList((Object[])new KeyValue[]{OafMapperUtils.keyValue((String)key, (String)value)});
    }
}

