/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.google.common.collect.Sets;
import eu.dnetlib.dhp.oa.dedup.model.Identifier;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.schema.oaf.utils.PidComparator;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class IdentifierComparator<T extends OafEntity>
implements Comparator<Identifier<T>> {
    public static int compareIdentifiers(Identifier left, Identifier right) {
        return new IdentifierComparator().compare(left, right);
    }

    @Override
    public int compare(Identifier<T> left, Identifier<T> i) {
        Set lKeys = Optional.ofNullable(left.getCollectedFrom()).map(c -> c.stream().map(KeyValue::getKey).collect(Collectors.toSet())).orElse(Sets.newHashSet());
        Optional<List<KeyValue>> cf = Optional.ofNullable(i.getCollectedFrom());
        Set rKeys = cf.map(c -> c.stream().map(KeyValue::getKey).collect(Collectors.toSet())).orElse(Sets.newHashSet());
        if (left.getPidType().compareTo((Enum)i.getPidType()) == 0) {
            if (left.getEntityType() == EntityType.publication) {
                if (this.isFromDatasourceID(lKeys, "10|openaire____::081b82f96300b6a6e3d282bad31cb6e2") && !this.isFromDatasourceID(rKeys, "10|openaire____::081b82f96300b6a6e3d282bad31cb6e2")) {
                    return -1;
                }
                if (this.isFromDatasourceID(rKeys, "10|openaire____::081b82f96300b6a6e3d282bad31cb6e2") && !this.isFromDatasourceID(lKeys, "10|openaire____::081b82f96300b6a6e3d282bad31cb6e2")) {
                    return 1;
                }
            }
            if (left.getEntityType() == EntityType.dataset) {
                if (this.isFromDatasourceID(lKeys, "10|openaire____::9e3be59865b2c1c335d32dae2fe7b254") && !this.isFromDatasourceID(rKeys, "10|openaire____::9e3be59865b2c1c335d32dae2fe7b254")) {
                    return -1;
                }
                if (this.isFromDatasourceID(rKeys, "10|openaire____::9e3be59865b2c1c335d32dae2fe7b254") && !this.isFromDatasourceID(lKeys, "10|openaire____::9e3be59865b2c1c335d32dae2fe7b254")) {
                    return 1;
                }
            }
            if (left.getDate().compareTo(i.getDate()) == 0) {
                return left.getOriginalID().compareTo(i.getOriginalID());
            }
            return left.getDate().compareTo(i.getDate());
        }
        return new PidComparator(left.getEntity()).compare(this.toSP(left.getPidType()), this.toSP(i.getPidType()));
    }

    public boolean isFromDatasourceID(Set<String> collectedFrom, String dsId) {
        return collectedFrom.contains(dsId);
    }

    private StructuredProperty toSP(PidType pidType) {
        return OafMapperUtils.structuredProperty((String)"", (String)pidType.toString(), (String)pidType.toString(), (String)"", (String)"", (DataInfo)new DataInfo());
    }
}

