/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.AbstractSparkAction;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.oa.dedup.SparkCopyRelationsNoOpenorgs;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkCopyRelationsForBroker
extends AbstractSparkAction {
    private static final Logger log = LoggerFactory.getLogger(SparkCopyRelationsNoOpenorgs.class);

    public SparkCopyRelationsForBroker(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCopyRelationsNoOpenorgs.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/copyRelationsForBroker_parameters.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.registerKryoClasses(ModelSupport.getOafModelClasses());
        new SparkCopyRelationsForBroker(parser, SparkCopyRelationsForBroker.getSparkSession(conf)).run(ISLookupClientFactory.getLookUpService((String)parser.get("isLookUpUrl")));
    }

    @Override
    public void run(ISLookUpService isLookUpService) throws IOException {
        String graphBasePath = this.parser.get("graphBasePath");
        String workingPath = this.parser.get("workingPath");
        String relationsOutputPath = this.parser.get("relationsOutputPath");
        log.info("graphBasePath:       '{}'", (Object)graphBasePath);
        log.info("workingPath:         '{}'", (Object)workingPath);
        log.info("relationsOutputPath: '{}'", (Object)relationsOutputPath);
        String relationPath = DedupUtility.createEntityPath(graphBasePath, "relation");
        JavaRDD relationsForBroker = this.spark.read().schema(Encoders.bean(Relation.class).schema()).json(relationPath).as(Encoders.bean(Relation.class)).map(SparkCopyRelationsForBroker.patchRelFn(), Encoders.bean(Relation.class)).toJavaRDD().filter(this::isNeededByBrokerRel);
        if (log.isDebugEnabled()) {
            log.debug("Number of relations needed by the broker collected: {}", (Object)relationsForBroker.count());
        }
        SparkCopyRelationsForBroker.save(this.spark.createDataset(relationsForBroker.rdd(), Encoders.bean(Relation.class)), relationsOutputPath, SaveMode.Overwrite);
    }
}

