/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.AbstractSparkAction;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkCopyRelationsNoOpenorgs
extends AbstractSparkAction {
    private static final Logger log = LoggerFactory.getLogger(SparkCopyRelationsNoOpenorgs.class);

    public SparkCopyRelationsNoOpenorgs(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCopyRelationsNoOpenorgs.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/updateEntity_parameters.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.registerKryoClasses(ModelSupport.getOafModelClasses());
        new SparkCopyRelationsNoOpenorgs(parser, SparkCopyRelationsNoOpenorgs.getSparkSession(conf)).run(ISLookupClientFactory.getLookUpService((String)parser.get("isLookUpUrl")));
    }

    @Override
    public void run(ISLookUpService isLookUpService) throws IOException {
        String graphBasePath = this.parser.get("graphBasePath");
        String workingPath = this.parser.get("workingPath");
        String dedupGraphPath = this.parser.get("dedupGraphPath");
        log.info("graphBasePath:  '{}'", (Object)graphBasePath);
        log.info("workingPath:    '{}'", (Object)workingPath);
        log.info("dedupGraphPath: '{}'", (Object)dedupGraphPath);
        String relationPath = DedupUtility.createEntityPath(graphBasePath, "relation");
        String outputPath = DedupUtility.createEntityPath(dedupGraphPath, "relation");
        Dataset simRels = this.spark.read().schema(Encoders.bean(Relation.class).schema()).json(relationPath).as(Encoders.bean(Relation.class)).flatMap((FlatMapFunction & Serializable)r -> {
            r = (Relation)SparkCopyRelationsNoOpenorgs.patchRelFn().call(r);
            if (!this.isOpenorgsDedupRel((Relation)r)) {
                return Collections.singletonList(r).iterator();
            }
            return Collections.emptyIterator();
        }, Encoders.bean(Relation.class));
        if (log.isDebugEnabled()) {
            log.debug("Number of non-Openorgs relations collected: {}", (Object)simRels.count());
        }
        SparkCopyRelationsNoOpenorgs.save(simRels, outputPath, SaveMode.Overwrite);
    }
}

