/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.AbstractSparkAction;
import eu.dnetlib.dhp.oa.dedup.DedupUtility;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SparkWhitelistSimRels
extends AbstractSparkAction {
    private static final Logger log = LoggerFactory.getLogger(SparkWhitelistSimRels.class);
    private static final String WHITELIST_SEPARATOR = "####";

    public SparkWhitelistSimRels(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkWhitelistSimRels.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/whitelistSimRels_parameters.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        new SparkWhitelistSimRels(parser, SparkWhitelistSimRels.getSparkSession(conf)).run(ISLookupClientFactory.getLookUpService((String)parser.get("isLookUpUrl")));
    }

    @Override
    public void run(ISLookUpService isLookUpService) throws DocumentException, IOException, ISLookUpException, SAXException {
        String graphBasePath = this.parser.get("graphBasePath");
        String isLookUpUrl = this.parser.get("isLookUpUrl");
        String actionSetId = this.parser.get("actionSetId");
        String workingPath = this.parser.get("workingPath");
        int numPartitions = Optional.ofNullable(this.parser.get("numPartitions")).map(Integer::valueOf).orElse(1000);
        String whiteListPath = this.parser.get("whiteListPath");
        log.info("numPartitions: '{}'", (Object)numPartitions);
        log.info("graphBasePath: '{}'", (Object)graphBasePath);
        log.info("isLookUpUrl:   '{}'", (Object)isLookUpUrl);
        log.info("actionSetId:   '{}'", (Object)actionSetId);
        log.info("workingPath:   '{}'", (Object)workingPath);
        log.info("whiteListPath: '{}'", (Object)whiteListPath);
        Dataset whiteListRels = this.spark.read().textFile(whiteListPath).withColumn("pairs", functions.split((Column)new Column("value"), (String)WHITELIST_SEPARATOR)).filter(functions.size((Column)new Column("pairs")).equalTo((Object)2)).select(new Column[]{functions.element_at((Column)new Column("pairs"), (Object)1).as("from"), functions.element_at((Column)new Column("pairs"), (Object)2).as("to")});
        for (DedupConfig dedupConf : this.getConfigurations(isLookUpService, actionSetId)) {
            String entity = dedupConf.getWf().getEntityType();
            String subEntity = dedupConf.getWf().getSubEntityValue();
            log.info("Adding whitelist simrels for: '{}'", (Object)subEntity);
            String outputPath = DedupUtility.createSimRelPath(workingPath, actionSetId, subEntity);
            Dataset entities = this.spark.read().textFile(DedupUtility.createEntityPath(graphBasePath, subEntity)).select(new Column[]{functions.get_json_object((Column)new Column("value"), (String)dedupConf.getWf().getIdPath()).as("id")}).distinct();
            Dataset whiteListSimRels = whiteListRels.join(entities, entities.col("id").equalTo((Object)whiteListRels.col("from")), "leftsemi").join(entities, functions.col((String)"to").equalTo((Object)entities.col("id")), "leftsemi").map((MapFunction & Serializable)r -> DedupUtility.createSimRel(r.getString(0), r.getString(1), entity), Encoders.bean(Relation.class));
            SparkWhitelistSimRels.saveParquet(whiteListSimRels, outputPath, SaveMode.Append);
        }
    }
}

