/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.dedup;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.dedup.APIResponse;
import eu.dnetlib.dhp.oa.dedup.ImportStatus;
import eu.dnetlib.dhp.oa.dedup.SparkCreateSimRels;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateOpenorgsJob {
    private static final Logger log = LoggerFactory.getLogger(UpdateOpenorgsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SparkCreateSimRels.class.getResourceAsStream("/eu/dnetlib/dhp/oa/dedup/updateOpenorgsJob_parameters.json")));
        parser.parseArgument(args);
        String apiUrl = parser.get("apiUrl");
        int delay = Integer.parseInt(parser.get("delay"));
        log.info("apiUrl: '{}'", (Object)apiUrl);
        log.info("delay: '{}'", (Object)delay);
        APIResponse res = UpdateOpenorgsJob.httpCall(apiUrl);
        while (res != null && res.getStatus().equals((Object)ImportStatus.RUNNING)) {
            TimeUnit.MINUTES.sleep(delay);
            res = UpdateOpenorgsJob.httpCall(apiUrl + "/status");
        }
        if (res == null) {
            log.error("Openorgs Update FAILED: No response");
            throw new RuntimeException("Openorgs Update FAILED: No response");
        }
        if (res.getStatus() == null || !res.getStatus().equals((Object)ImportStatus.SUCCESS)) {
            log.error("Openorgs Update FAILED: '{}' - '{}'", (Object)res.getStatus(), (Object)res.getMessage());
            throw new RuntimeException(res.getMessage());
        }
    }

    private static APIResponse httpCall(String url) throws Exception {
        HttpGet req = new HttpGet(url);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            APIResponse aPIResponse;
            block12: {
                CloseableHttpResponse response = client.execute((HttpUriRequest)req);
                try {
                    String s = IOUtils.toString((InputStream)response.getEntity().getContent());
                    aPIResponse = (APIResponse)new ObjectMapper().readValue(s, APIResponse.class);
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return aPIResponse;
        }
    }
}

