/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.doiboost.orcid;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.doiboost.DoiBoostMappingUtil$;
import eu.dnetlib.doiboost.orcid.ORCIDItem;
import eu.dnetlib.doiboost.orcid.OrcidAuthor;
import eu.dnetlib.doiboost.orcid.OrcidWork;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.package$;
import scala.reflect.ManifestFactory$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class ORCIDToOAF$ {
    public static final ORCIDToOAF$ MODULE$;
    private final Logger logger;
    private final ObjectMapper mapper;

    static {
        new ORCIDToOAF$();
    }

    public Logger logger() {
        return this.logger;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public boolean isJsonValid(String inputStr) {
        boolean bl;
        try {
            this.mapper().readTree(inputStr);
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public Tuple2<String, String> extractValueFromInputString(String input) {
        int i = input.indexOf(91);
        if (i < 5) {
            return null;
        }
        String orcidList = input.substring(i, input.length() - 1);
        String doi = input.substring(1, i - 1);
        return this.isJsonValid(orcidList) ? new Tuple2((Object)doi, (Object)orcidList) : null;
    }

    public boolean strValid(Option<String> s) {
        return s.isDefined() && new StringOps(Predef$.MODULE$.augmentString((String)s.get())).nonEmpty();
    }

    public boolean authorValid(OrcidAuthor author) {
        if (this.strValid(author.name()) && this.strValid(author.surname())) {
            return true;
        }
        if (this.strValid(author.surname())) {
            return true;
        }
        return this.strValid(author.creditName());
    }

    public List<OrcidWork> extractDOIWorks(String input) {
        VolatileByteRef bitmap$0;
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        String oid = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(org.json4s.package$.MODULE$.jvalue2monadic(this.json$1(input, json$lzy, bitmap$0 = VolatileByteRef.create((byte)0))).$bslash("workDetail")).$bslash("oid")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
        if (oid == null) {
            return Nil$.MODULE$;
        }
        List doi = org.json4s.package$.MODULE$.jvalue2monadic(org.json4s.package$.MODULE$.jvalue2monadic(org.json4s.package$.MODULE$.jvalue2monadic(this.json$1(input, json$lzy, bitmap$0)).$bslash("workDetail")).$bslash("extIds")).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$1) {
                JsonAST.JValue jValue = check$ifrefutable$1;
                boolean bl = jValue instanceof JsonAST.JObject;
                return bl;
            }
        }).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Tuple2<String, String>> apply(JsonAST.JValue x$4) {
                JsonAST.JValue jValue = x$4;
                if (jValue instanceof JsonAST.JObject) {
                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                    List extIds = jObject.obj();
                    List list = (List)extIds.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$2) {
                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$2;
                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                            if (option.isEmpty()) return false;
                            String string = (String)((Tuple2)option.get())._1();
                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                            if (!"type".equals(string)) return false;
                            if (!(jValue instanceof JsonAST.JString)) return false;
                            return true;
                        }
                    }).flatMap((Function1)new Serializable(this, extIds){
                        public static final long serialVersionUID = 0L;
                        private final List extIds$1;

                        public final List<Tuple2<String, String>> apply(Tuple2<String, JsonAST.JValue> x$3) {
                            Tuple2<String, JsonAST.JValue> tuple2 = x$3;
                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                            if (!option.isEmpty()) {
                                String string = (String)((Tuple2)option.get())._1();
                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                if ("type".equals(string) && jValue instanceof JsonAST.JString) {
                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                    String typeValue = jString.s();
                                    List list = (List)this.extIds$1.withFilter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$3) {
                                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$3;
                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                            if (option.isEmpty()) return false;
                                            String string = (String)((Tuple2)option.get())._1();
                                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                            if (!"value".equals(string)) return false;
                                            if (!(jValue instanceof JsonAST.JString)) return false;
                                            return true;
                                        }
                                    }).withFilter((Function1)new Serializable(this, typeValue){
                                        public static final long serialVersionUID = 0L;
                                        private final String typeValue$1;

                                        public final boolean apply(Tuple2<String, JsonAST.JValue> x$1) {
                                            Tuple2<String, JsonAST.JValue> tuple2 = x$1;
                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                            if (!option.isEmpty()) {
                                                String string = (String)((Tuple2)option.get())._1();
                                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                if ("value".equals(string) && jValue instanceof JsonAST.JString) {
                                                    boolean bl = "doi".equalsIgnoreCase(this.typeValue$1);
                                                    return bl;
                                                }
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            this.typeValue$1 = typeValue$1;
                                        }
                                    }).map((Function1)new Serializable(this, typeValue){
                                        public static final long serialVersionUID = 0L;
                                        private final String typeValue$1;

                                        public final Tuple2<String, String> apply(Tuple2<String, JsonAST.JValue> x$2) {
                                            Tuple2<String, JsonAST.JValue> tuple2 = x$2;
                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                            if (!option.isEmpty()) {
                                                String string = (String)((Tuple2)option.get())._1();
                                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                if ("value".equals(string) && jValue instanceof JsonAST.JString) {
                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                    String value = jString.s();
                                                    Tuple2 tuple22 = new Tuple2((Object)this.typeValue$1, (Object)DoiBoostMappingUtil$.MODULE$.normalizeDoi(value));
                                                    return tuple22;
                                                }
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            this.typeValue$1 = typeValue$1;
                                        }
                                    }, List$.MODULE$.canBuildFrom());
                                    return list;
                                }
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.extIds$1 = extIds$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    return list;
                }
                throw new MatchError((Object)jValue);
            }
        });
        if (doi.nonEmpty()) {
            return (List)doi.map((Function1)new Serializable(oid){
                public static final long serialVersionUID = 0L;
                private final String oid$1;

                public final OrcidWork apply(Tuple2<String, String> l) {
                    return new OrcidWork(this.oid$1, (String)l._2());
                }
                {
                    this.oid$1 = oid$1;
                }
            }, List$.MODULE$.canBuildFrom());
        }
        return Nil$.MODULE$;
    }

    public OrcidAuthor convertORCIDAuthor(String input) {
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        return (OrcidAuthor)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(this.json$2(input, json$lzy, bitmap$0)).$bslash("authorData")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(OrcidAuthor.class));
    }

    public Publication convertTOOAF(ORCIDItem input) {
        Publication publication;
        String doi = input.doi();
        Publication pub = new Publication();
        pub.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{DoiBoostMappingUtil$.MODULE$.createSP(doi, "doi", "dnet:pid_types")}))).asJava());
        pub.setDataInfo(DoiBoostMappingUtil$.MODULE$.generateDataInfo());
        pub.setId(IdentifierFactory.createDOIBoostIdentifier((Result)pub));
        if (pub.getId() == null) {
            return null;
        }
        try {
            List l = (List)input.authors().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Author apply(OrcidAuthor a) {
                    return ORCIDToOAF$.MODULE$.generateAuthor(a);
                }
            }, package$.MODULE$.breakOut(List$.MODULE$.canBuildFrom()));
            pub.setAuthor((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)l).asJava());
            pub.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{DoiBoostMappingUtil$.MODULE$.createORIDCollectedFrom()}))).asJava());
            pub.setDataInfo(DoiBoostMappingUtil$.MODULE$.generateDataInfo());
            publication = pub;
        }
        catch (Throwable throwable) {
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR ON GENERATE Publication from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input})));
            publication = null;
        }
        return publication;
    }

    /*
     * WARNING - void declaration
     */
    public DataInfo generateOricPIDDatainfo() {
        void var1_1;
        DataInfo di = DoiBoostMappingUtil$.MODULE$.generateDataInfo("0.91");
        di.getProvenanceaction().setClassid("sysimport:crosswalk:entityregistry");
        di.getProvenanceaction().setClassname("Harvested");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Author generateAuthor(OrcidAuthor o) {
        void var2_2;
        Author a = new Author();
        if (this.strValid(o.name())) {
            a.setName(new StringOps(Predef$.MODULE$.augmentString((String)o.name().get())).capitalize());
        }
        if (this.strValid(o.surname())) {
            a.setSurname(new StringOps(Predef$.MODULE$.augmentString((String)o.surname().get())).capitalize());
        }
        if (this.strValid(o.name()) && this.strValid(o.surname())) {
            a.setFullname(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString((String)o.name().get())).capitalize(), new StringOps(Predef$.MODULE$.augmentString((String)o.surname().get())).capitalize()})));
        } else if (this.strValid(o.creditName())) {
            a.setFullname((String)o.creditName().get());
        }
        if (StringUtils.isNotBlank((String)o.oid())) {
            a.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{DoiBoostMappingUtil$.MODULE$.createSP(o.oid(), "orcid", "dnet:pid_types", this.generateOricPIDDatainfo())}))).asJava());
        }
        return var2_2;
    }

    private final DefaultFormats$ formats$lzycompute$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        ORCIDToOAF$ oRCIDToOAF$ = this;
        synchronized (oRCIDToOAF$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                formats$lzy$1.elem = DefaultFormats$.MODULE$;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$1.elem;
        }
    }

    private final DefaultFormats$ formats$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.formats$lzycompute$1(formats$lzy$1, bitmap$0$1) : (DefaultFormats$)formats$lzy$1.elem;
    }

    private final JsonAST.JValue json$lzycompute$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        ORCIDToOAF$ oRCIDToOAF$ = this;
        synchronized (oRCIDToOAF$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                json$lzy$1.elem = JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(input$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$1.elem;
        }
    }

    private final JsonAST.JValue json$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.json$lzycompute$1(input$1, json$lzy$1, bitmap$0$1) : (JsonAST.JValue)json$lzy$1.elem;
    }

    private final DefaultFormats$ formats$lzycompute$2(ObjectRef formats$lzy$2, VolatileByteRef bitmap$0$2) {
        ORCIDToOAF$ oRCIDToOAF$ = this;
        synchronized (oRCIDToOAF$) {
            if ((byte)(bitmap$0$2.elem & 1) == 0) {
                formats$lzy$2.elem = DefaultFormats$.MODULE$;
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$2.elem;
        }
    }

    private final DefaultFormats$ formats$2(ObjectRef formats$lzy$2, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 1) == 0 ? this.formats$lzycompute$2(formats$lzy$2, bitmap$0$2) : (DefaultFormats$)formats$lzy$2.elem;
    }

    private final JsonAST.JValue json$lzycompute$2(String input$2, ObjectRef json$lzy$2, VolatileByteRef bitmap$0$2) {
        ORCIDToOAF$ oRCIDToOAF$ = this;
        synchronized (oRCIDToOAF$) {
            if ((byte)(bitmap$0$2.elem & 2) == 0) {
                json$lzy$2.elem = JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(input$2), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$2.elem;
        }
    }

    private final JsonAST.JValue json$2(String input$2, ObjectRef json$lzy$2, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 2) == 0 ? this.json$lzycompute$2(input$2, json$lzy$2, bitmap$0$2) : (JsonAST.JValue)json$lzy$2.elem;
    }

    private ORCIDToOAF$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.mapper = new ObjectMapper();
    }
}

