/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.bulktag.community;

import com.google.gson.Gson;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import eu.dnetlib.dhp.bulktag.community.CommunityConfiguration;
import eu.dnetlib.dhp.bulktag.eosc.EoscIFTag;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultTagger
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ResultTagger.class);

    private boolean clearContext(Result result) {
        int tmp = result.getContext().size();
        List clist = result.getContext().stream().filter(c -> !c.getId().contains("zenodo.org/communities/")).collect(Collectors.toList());
        result.setContext(clist);
        return tmp != clist.size();
    }

    private Map<String, List<String>> getParamMap(Result result, Map<String, String> params) {
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        String json = new Gson().toJson((Object)result, Result.class);
        DocumentContext jsonContext = JsonPath.parse((String)json);
        if (params == null) {
            params = new HashMap<String, String>();
        }
        for (String key : params.keySet()) {
            try {
                param.put(key, (List<String>)jsonContext.read(params.get(key), new Predicate[0]));
            }
            catch (PathNotFoundException e) {
                param.put(key, new ArrayList());
            }
        }
        return param;
    }

    public <R extends Result> R enrichContextCriteria(R result, CommunityConfiguration conf, Map<String, String> criteria) {
        Map<String, List<String>> param = this.getParamMap(result, criteria);
        if (result.getDataInfo().getDeletedbyinference().booleanValue()) {
            this.clearContext(result);
            return result;
        }
        switch (result.getResulttype().getClassid()) {
            case "publication": {
                break;
            }
            case "software": {
                EoscIFTag.tagForSoftware(result);
                break;
            }
            case "dataset": {
                EoscIFTag.tagForDataset(result);
                break;
            }
            case "other": {
                EoscIFTag.tagForOther(result);
            }
        }
        HashSet removeCommunities = new HashSet();
        conf.getRemoveConstraintsMap().keySet().forEach(communityId -> {
            if (conf.getRemoveConstraintsMap().keySet().contains(communityId) && conf.getRemoveConstraintsMap().get(communityId).getCriteria() != null && conf.getRemoveConstraintsMap().get(communityId).getCriteria().stream().anyMatch(crit -> crit.verifyCriteria(param))) {
                removeCommunities.add(communityId);
            }
        });
        HashSet communities = new HashSet();
        HashSet subjects = new HashSet();
        if (Objects.nonNull(result.getSubject())) {
            result.getSubject().stream().map(StructuredProperty::getValue).filter(StringUtils::isNotBlank).map(String::toLowerCase).map(String::trim).collect(Collectors.toCollection(HashSet::new)).forEach(s -> subjects.addAll(conf.getCommunityForSubjectValue((String)s)));
        }
        communities.addAll(subjects);
        HashSet datasources = new HashSet();
        HashSet<String> collfrom = new HashSet<String>();
        HashSet<String> hostdby = new HashSet<String>();
        if (Objects.nonNull(result.getInstance())) {
            for (Instance i : result.getInstance()) {
                if (Objects.nonNull(i.getCollectedfrom()) && Objects.nonNull(i.getCollectedfrom().getKey())) {
                    collfrom.add(i.getCollectedfrom().getKey());
                }
                if (!Objects.nonNull(i.getHostedby()) || !Objects.nonNull(i.getHostedby().getKey())) continue;
                hostdby.add(i.getHostedby().getKey());
            }
            collfrom.forEach(dsId -> datasources.addAll(conf.getCommunityForDatasource((String)dsId, param)));
            hostdby.forEach(dsId -> {
                datasources.addAll(conf.getCommunityForDatasource((String)dsId, param));
                if (conf.isEoscDatasource((String)dsId)) {
                    datasources.add("eosc");
                }
            });
        }
        communities.addAll(datasources);
        HashSet czenodo = new HashSet();
        Optional<List> oresultcontext = Optional.ofNullable(result.getContext());
        if (oresultcontext.isPresent()) {
            oresultcontext.get().stream().filter(c -> c.getId().contains("zenodo.org/communities/")).collect(Collectors.toList()).forEach(c -> czenodo.addAll(conf.getCommunityForZenodoCommunityValue(c.getId().substring(c.getId().lastIndexOf("/") + 1).trim())));
        }
        communities.addAll(czenodo);
        HashSet aconstraints = new HashSet();
        conf.getSelectionConstraintsMap().keySet().forEach(communityId -> {
            if (!removeCommunities.contains(communityId) && conf.getSelectionConstraintsMap().get(communityId).getCriteria() != null && conf.getSelectionConstraintsMap().get(communityId).getCriteria().stream().anyMatch(crit -> crit.verifyCriteria(param))) {
                aconstraints.add(communityId);
            }
        });
        communities.addAll(aconstraints);
        communities.removeAll(removeCommunities);
        if (aconstraints.size() > 0) {
            log.info("Found {} for advancedConstraints ", (Object)aconstraints.size());
        }
        this.clearContext(result);
        if (communities.isEmpty()) {
            return result;
        }
        result.getContext().forEach(c -> {
            String cId = c.getId();
            if (communities.contains(cId)) {
                ArrayList<DataInfo> dataInfoList;
                Optional<List> opt_dataInfoList = Optional.ofNullable(c.getDataInfo());
                if (opt_dataInfoList.isPresent()) {
                    dataInfoList = opt_dataInfoList.get();
                } else {
                    dataInfoList = new ArrayList<DataInfo>();
                    c.setDataInfo(dataInfoList);
                }
                if (subjects.contains(cId)) {
                    dataInfoList.add(OafMapperUtils.dataInfo((Boolean)false, (String)"bulktagging", (Boolean)true, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)"community:subject", (String)"Bulktagging for Community - Subject", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), (String)"0.8"));
                }
                if (datasources.contains(cId)) {
                    dataInfoList.add(OafMapperUtils.dataInfo((Boolean)false, (String)"bulktagging", (Boolean)true, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)"community:datasource", (String)"Bulktagging for Community - Datasource", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), (String)"0.8"));
                }
                if (czenodo.contains(cId)) {
                    dataInfoList.add(OafMapperUtils.dataInfo((Boolean)false, (String)"bulktagging", (Boolean)true, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)"community:zenodocommunity", (String)"Bulktagging for Community - Zenodo", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), (String)"0.8"));
                }
                if (aconstraints.contains(cId)) {
                    dataInfoList.add(OafMapperUtils.dataInfo((Boolean)false, (String)"bulktagging", (Boolean)true, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)"community:advconstraint", (String)"Bulktagging for Community - Advanced Constraints", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), (String)"0.8"));
                }
            }
        });
        communities.removeAll(result.getContext().stream().map(Context::getId).collect(Collectors.toSet()));
        if (communities.isEmpty()) {
            return result;
        }
        List toaddcontext = communities.stream().map(c -> {
            Context context = new Context();
            context.setId(c);
            ArrayList<DataInfo> dataInfoList = new ArrayList<DataInfo>();
            if (subjects.contains(c)) {
                dataInfoList.add(OafMapperUtils.dataInfo((Boolean)false, (String)"bulktagging", (Boolean)true, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)"community:subject", (String)"Bulktagging for Community - Subject", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), (String)"0.8"));
            }
            if (datasources.contains(c)) {
                dataInfoList.add(OafMapperUtils.dataInfo((Boolean)false, (String)"bulktagging", (Boolean)true, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)"community:datasource", (String)"Bulktagging for Community - Datasource", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), (String)"0.8"));
            }
            if (czenodo.contains(c)) {
                dataInfoList.add(OafMapperUtils.dataInfo((Boolean)false, (String)"bulktagging", (Boolean)true, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)"community:zenodocommunity", (String)"Bulktagging for Community - Zenodo", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), (String)"0.8"));
            }
            if (aconstraints.contains(c)) {
                dataInfoList.add(OafMapperUtils.dataInfo((Boolean)false, (String)"bulktagging", (Boolean)true, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)"community:advconstraint", (String)"Bulktagging for Community - Advanced Constraints", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), (String)"0.8"));
            }
            context.setDataInfo(dataInfoList);
            return context;
        }).collect(Collectors.toList());
        result.getContext().addAll(toaddcontext);
        return result;
    }
}

