/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.person;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.person.SparkExtractPersonRelations;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonPropagationJobTest {
    private static final Logger log = LoggerFactory.getLogger(PersonPropagationJobTest.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(PersonPropagationJobTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(PersonPropagationJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PersonPropagationJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testPersonPropagation() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/personpropagation/graph").getPath();
        SparkExtractPersonRelations.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", sourcePath, "--outputPath", workingDir.toString()});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/relation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
    }
}

