/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.resulttocommunityfromorganization;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.orcidtoresultfromsemrel.OrcidPropagationJobTest;
import eu.dnetlib.dhp.resulttocommunityfromorganization.SparkResultToCommunityFromOrganizationJob;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultToCommunityJobTest {
    private static final Logger log = LoggerFactory.getLogger(ResultToCommunityJobTest.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static SparkSession spark;
    private static Path workingDir;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(ResultToCommunityJobTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(ResultToCommunityJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(OrcidPropagationJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testSparkResultToCommunityFromOrganizationJob() throws Exception {
        String preparedInfoPath = this.getClass().getResource("/eu/dnetlib/dhp/resulttocommunityfromorganization/preparedInfo").getPath();
        SparkResultToCommunityFromOrganizationJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", this.getClass().getResource("/eu/dnetlib/dhp/resulttocommunityfromorganization/sample/").getPath(), "-outputPath", workingDir.toString() + "/", "-preparedInfoPath", preparedInfoPath});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/dataset").map((Function & Serializable)item -> (Dataset)OBJECT_MAPPER.readValue(item, Dataset.class));
        Assertions.assertEquals((long)10L, (long)tmp.count());
        org.apache.spark.sql.Dataset verificationDataset = spark.createDataset(tmp.rdd(), Encoders.bean(Dataset.class));
        verificationDataset.createOrReplaceTempView("dataset");
        String query = "select id, MyT.id community from dataset lateral view explode(context) c as MyT lateral view explode(MyT.datainfo) d as MyD where MyD.inferenceprovenance = 'propagation'";
        org.apache.spark.sql.Dataset resultExplodedProvenance = spark.sql(query);
        Assertions.assertEquals((long)5L, (long)resultExplodedProvenance.count());
        Assertions.assertEquals((long)0L, (long)resultExplodedProvenance.filter("id = '50|dedup_wf_001::afaf128022d29872c4dad402b2db04fe'").count());
        Assertions.assertEquals((long)1L, (long)resultExplodedProvenance.filter("id = '50|dedup_wf_001::3f62cfc27024d564ea86760c494ba93b'").count());
        Assertions.assertEquals((Object)"beopen", (Object)((Row)resultExplodedProvenance.select("community", new String[0]).where(resultExplodedProvenance.col("id").equalTo((Object)"50|dedup_wf_001::3f62cfc27024d564ea86760c494ba93b")).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((long)2L, (long)resultExplodedProvenance.filter("id = '50|od________18::8887b1df8b563c4ea851eb9c882c9d7b'").count());
        Assertions.assertEquals((Object)"mes", (Object)((Row)resultExplodedProvenance.select("community", new String[0]).where(resultExplodedProvenance.col("id").equalTo((Object)"50|od________18::8887b1df8b563c4ea851eb9c882c9d7b")).sort(new Column[]{functions.desc((String)"community")}).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"euromarine", (Object)((Row)resultExplodedProvenance.select("community", new String[0]).where(resultExplodedProvenance.col("id").equalTo((Object)"50|od________18::8887b1df8b563c4ea851eb9c882c9d7b")).sort(new Column[]{functions.desc((String)"community")}).collectAsList().get(1)).getString(0));
        Assertions.assertEquals((long)1L, (long)resultExplodedProvenance.filter("id = '50|doajarticles::8d817039a63710fcf97e30f14662c6c8'").count());
        Assertions.assertEquals((Object)"mes", (Object)((Row)resultExplodedProvenance.select("community", new String[0]).where(resultExplodedProvenance.col("id").equalTo((Object)"50|doajarticles::8d817039a63710fcf97e30f14662c6c8")).sort(new Column[]{functions.desc((String)"community")}).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((long)1L, (long)resultExplodedProvenance.filter("id = '50|doajarticles::3c98f0632f1875b4979e552ba3aa01e6'").count());
        Assertions.assertEquals((Object)"mes", (Object)((Row)resultExplodedProvenance.select("community", new String[0]).where(resultExplodedProvenance.col("id").equalTo((Object)"50|doajarticles::3c98f0632f1875b4979e552ba3aa01e6")).sort(new Column[]{functions.desc((String)"community")}).collectAsList().get(0)).getString(0));
        query = "select id, MyT.id community from dataset lateral view explode(context) c as MyT lateral view explode(MyT.datainfo) d as MyD ";
        org.apache.spark.sql.Dataset resultCommunityId = spark.sql(query);
        Assertions.assertEquals((long)10L, (long)resultCommunityId.count());
        Assertions.assertEquals((long)1L, (long)resultCommunityId.filter("id = '50|dedup_wf_001::afaf128022d29872c4dad402b2db04fe'").count());
        Assertions.assertEquals((Object)"beopen", (Object)((Row)resultCommunityId.select("community", new String[0]).where(resultCommunityId.col("id").equalTo((Object)"50|dedup_wf_001::afaf128022d29872c4dad402b2db04fe")).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((long)1L, (long)resultCommunityId.filter("id = '50|dedup_wf_001::3f62cfc27024d564ea86760c494ba93b'").count());
        Assertions.assertEquals((long)3L, (long)resultCommunityId.filter("id = '50|od________18::8887b1df8b563c4ea851eb9c882c9d7b'").count());
        Assertions.assertEquals((Object)"beopen", (Object)((Row)resultCommunityId.select("community", new String[0]).where(resultCommunityId.col("id").equalTo((Object)"50|od________18::8887b1df8b563c4ea851eb9c882c9d7b")).sort(new Column[]{functions.desc((String)"community")}).collectAsList().get(2)).getString(0));
        Assertions.assertEquals((long)2L, (long)resultCommunityId.filter("id = '50|doajarticles::8d817039a63710fcf97e30f14662c6c8'").count());
        Assertions.assertEquals((Object)"euromarine", (Object)((Row)resultCommunityId.select("community", new String[0]).where(resultCommunityId.col("id").equalTo((Object)"50|doajarticles::8d817039a63710fcf97e30f14662c6c8")).sort(new Column[]{functions.desc((String)"community")}).collectAsList().get(1)).getString(0));
        Assertions.assertEquals((long)3L, (long)resultCommunityId.filter("id = '50|doajarticles::3c98f0632f1875b4979e552ba3aa01e6'").count());
        Assertions.assertEquals((Object)"euromarine", (Object)((Row)resultCommunityId.select("community", new String[0]).where(resultCommunityId.col("id").equalTo((Object)"50|doajarticles::3c98f0632f1875b4979e552ba3aa01e6")).sort(new Column[]{functions.desc((String)"community")}).collectAsList().get(2)).getString(0));
        Assertions.assertEquals((Object)"ni", (Object)((Row)resultCommunityId.select("community", new String[0]).where(resultCommunityId.col("id").equalTo((Object)"50|doajarticles::3c98f0632f1875b4979e552ba3aa01e6")).sort(new Column[]{functions.desc((String)"community")}).collectAsList().get(0)).getString(0));
    }
}

