/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.bulktag.community;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.dhp.bulktag.community.Community;
import eu.dnetlib.dhp.bulktag.community.CommunityConfiguration;
import eu.dnetlib.dhp.bulktag.community.Provider;
import eu.dnetlib.dhp.bulktag.community.SelectionConstraints;
import eu.dnetlib.dhp.bulktag.criteria.InterfaceAdapter;
import eu.dnetlib.dhp.bulktag.criteria.Selection;
import eu.dnetlib.dhp.bulktag.criteria.VerbResolver;
import eu.dnetlib.dhp.bulktag.criteria.VerbResolverFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class CommunityConfigurationFactory {
    private static final Log log = LogFactory.getLog(CommunityConfigurationFactory.class);
    private static final VerbResolver resolver = VerbResolverFactory.newInstance();

    private CommunityConfigurationFactory() {
    }

    public static CommunityConfiguration newInstance(String xml) throws DocumentException, SAXException {
        log.info((Object)String.format("parsing community configuration from:\n%s", xml));
        SAXReader reader = new SAXReader();
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        Document doc = reader.read((Reader)new StringReader(xml));
        HashMap communities = Maps.newHashMap();
        for (Object o : doc.selectNodes("//community")) {
            Node node = (Node)o;
            Community community = CommunityConfigurationFactory.parseCommunity(node);
            if (!community.isValid()) continue;
            communities.put(community.getId(), community);
        }
        log.info((Object)String.format("loaded %s community configuration profiles", communities.size()));
        log.debug((Object)String.format("loaded community configuration:\n%s", communities));
        return new CommunityConfiguration(communities);
    }

    public static CommunityConfiguration fromJson(String json) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Selection.class, (Object)new InterfaceAdapter());
        Gson gson = builder.create();
        CommunityConfiguration conf = (CommunityConfiguration)gson.fromJson(json, CommunityConfiguration.class);
        log.info((Object)String.format("loaded %s community configuration profiles", conf.size()));
        conf.init();
        log.info((Object)"created inverse maps");
        return conf;
    }

    private static Community parseCommunity(Node node) {
        Community c = new Community();
        c.setId(node.valueOf("./@id"));
        log.info((Object)String.format("community id: %s", c.getId()));
        c.setSubjects(CommunityConfigurationFactory.parseSubjects(node));
        c.setProviders(CommunityConfigurationFactory.parseDatasources(node));
        c.setZenodoCommunities(CommunityConfigurationFactory.parseZenodoCommunities(node));
        c.setConstraints(CommunityConfigurationFactory.parseConstrains(node));
        c.setRemoveConstraints(CommunityConfigurationFactory.parseRemoveConstrains(node));
        return c;
    }

    private static SelectionConstraints parseConstrains(Node node) {
        Node advConstsNode = node.selectSingleNode("./advancedConstraints");
        if (advConstsNode == null || StringUtils.isBlank((CharSequence)StringUtils.trim((String)advConstsNode.getText()))) {
            return new SelectionConstraints();
        }
        SelectionConstraints selectionConstraints = (SelectionConstraints)new Gson().fromJson(advConstsNode.getText(), SelectionConstraints.class);
        selectionConstraints.setSelection(resolver);
        log.info((Object)("number of selection constraints set " + selectionConstraints.getCriteria().size()));
        return selectionConstraints;
    }

    private static SelectionConstraints parseRemoveConstrains(Node node) {
        Node constsNode = node.selectSingleNode("./removeConstraints");
        if (constsNode == null || StringUtils.isBlank((CharSequence)StringUtils.trim((String)constsNode.getText()))) {
            return new SelectionConstraints();
        }
        SelectionConstraints selectionConstraints = (SelectionConstraints)new Gson().fromJson(constsNode.getText(), SelectionConstraints.class);
        selectionConstraints.setSelection(resolver);
        log.info((Object)("number of selection constraints set " + selectionConstraints.getCriteria().size()));
        return selectionConstraints;
    }

    private static List<String> parseSubjects(Node node) {
        ArrayList subjects = Lists.newArrayList();
        List list = node.selectNodes("./subjects/subject");
        for (Node n : list) {
            log.debug((Object)("text of the node " + n.getText()));
            subjects.add(StringUtils.trim((String)n.getText()));
        }
        log.info((Object)("size of the subject list " + subjects.size()));
        return subjects;
    }

    private static List<Provider> parseDatasources(Node node) {
        List list = node.selectNodes("./datasources/datasource");
        ArrayList<Provider> providerList = new ArrayList<Provider>();
        for (Node n : list) {
            Provider d = new Provider();
            d.setOpenaireId(n.selectSingleNode("./openaireId").getText());
            d.setSelCriteria(n.selectSingleNode("./selcriteria"), resolver);
            providerList.add(d);
        }
        log.info((Object)("size of the datasource list " + providerList.size()));
        return providerList;
    }

    private static List<String> parseZenodoCommunities(Node node) {
        List list = node.selectNodes("./zenodocommunities/zenodocommunity");
        ArrayList<String> zenodoCommunityList = new ArrayList<String>();
        for (Node n : list) {
            zenodoCommunityList.add(n.selectSingleNode("./zenodoid").getText());
        }
        log.info((Object)("size of the zenodo community list " + zenodoCommunityList.size()));
        return zenodoCommunityList;
    }
}

