
package eu.dnetlib.dhp.bulktag.criteria;

import java.lang.reflect.Type;

import com.google.gson.*;

public class InterfaceAdapter implements JsonSerializer, JsonDeserializer {

	private static final String CLASSNAME = "CLASSNAME";
	private static final String DATA = "DATA";

	public Object deserialize(
		JsonElement jsonElement,
		Type type,
		JsonDeserializationContext jsonDeserializationContext)
		throws JsonParseException {

		JsonObject jsonObject = jsonElement.getAsJsonObject();
		JsonPrimitive prim = (JsonPrimitive) jsonObject.get(CLASSNAME);
		String className = prim.getAsString();
		Class klass = getObjectClass(className);
		return jsonDeserializationContext.deserialize(jsonObject.get(DATA), klass);
	}

	public JsonElement serialize(
		Object jsonElement, Type type, JsonSerializationContext jsonSerializationContext) {
		JsonObject jsonObject = new JsonObject();
		jsonObject.addProperty(CLASSNAME, jsonElement.getClass().getName());
		jsonObject.add(DATA, jsonSerializationContext.serialize(jsonElement));
		return jsonObject;
	}

	/** **** Helper method to get the className of the object to be deserialized **** */
	public Class getObjectClass(String className) {
		try {
			return Class.forName(className);
		} catch (ClassNotFoundException e) {
			// e.printStackTrace();
			throw new JsonParseException(e.getMessage());
		}
	}
}
