/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.entitytoorganizationfromsemrel;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.KeyValueSet;
import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.entitytoorganizationfromsemrel.Leaves;
import eu.dnetlib.dhp.entitytoorganizationfromsemrel.PrepareInfoJobTest;
import eu.dnetlib.dhp.entitytoorganizationfromsemrel.SparkEntityToOrganizationFromSemRel;
import eu.dnetlib.dhp.entitytoorganizationfromsemrel.StepActionsTest;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkJobTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(StepActionsTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(PrepareInfoJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PrepareInfoJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterEach
    public void afterEach() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    public void completeResultExecution() throws Exception {
        String graphPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/graph").getPath();
        String leavesPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/currentIteration/").getPath();
        String childParentPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/childParentOrg/").getPath();
        String resultOrgPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/resultOrganization/").getPath();
        String projectOrgPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/projectOrganization/").getPath();
        PropagationConstant.readPath((SparkSession)spark, (String)leavesPath, Leaves.class).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(workingDir.toString() + "/leavesInput");
        PropagationConstant.readPath((SparkSession)spark, (String)resultOrgPath, KeyValueSet.class).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(workingDir.toString() + "/orgsInput");
        PropagationConstant.readPath((SparkSession)spark, (String)projectOrgPath, KeyValueSet.class).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(workingDir.toString() + "/projectInput");
        SparkEntityToOrganizationFromSemRel.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-relationPath", graphPath, "-hive_metastore_uris", "", "-outputPath", workingDir.toString() + "/finalrelation", "-leavesPath", workingDir.toString() + "/leavesInput", "-resultOrgPath", workingDir.toString() + "/orgsInput", "-projectOrganizationPath", workingDir.toString() + "/projectInput", "-childParentPath", childParentPath, "-workingDir", workingDir.toString()});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD temp = sc.textFile(workingDir.toString() + "/finalrelation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Assertions.assertEquals((long)36L, (long)temp.count());
        JavaRDD result = temp.filter((Function & Serializable)r -> r.getSource().startsWith("50|") || r.getTarget().startsWith("50|"));
        Assertions.assertEquals((long)18L, (long)result.count());
        result.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"affiliation", (Object)r.getSubRelType()));
        result.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"resultOrganization", (Object)r.getRelType()));
        result.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"propagation", (Object)r.getDataInfo().getInferenceprovenance()));
        result.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"result:organization:semrel", (Object)r.getDataInfo().getProvenanceaction().getClassid()));
        result.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"Propagation of affiliation to result through semantic relations", (Object)r.getDataInfo().getProvenanceaction().getClassname()));
        result.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"0.85", (Object)r.getDataInfo().getTrust()));
        Assertions.assertEquals((long)9L, (long)result.filter((Function & Serializable)r -> r.getSource().substring(0, 3).equals("50|")).count());
        result.filter((Function & Serializable)r -> r.getSource().substring(0, 3).equals("50|")).foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"hasAuthorInstitution", (Object)r.getRelClass()));
        Assertions.assertEquals((long)2L, (long)result.filter((Function & Serializable)r -> r.getSource().equals("50|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).count());
        Assertions.assertEquals((long)3L, (long)result.filter((Function & Serializable)r -> r.getSource().equals("50|dedup_wf_001::2899e571609779168222fdeb59cb916d")).count());
        Assertions.assertEquals((long)2L, (long)result.filter((Function & Serializable)r -> r.getSource().equals("50|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).count());
        Assertions.assertEquals((long)1L, (long)result.filter((Function & Serializable)r -> r.getSource().equals("50|openaire____::ec653e804967133b9436fdd30d3ff51d")).count());
        Assertions.assertEquals((long)1L, (long)result.filter((Function & Serializable)r -> r.getSource().equals("50|doajarticles::03748bcb5d754c951efec9700e18a56d")).count());
        Assertions.assertEquals((long)9L, (long)result.filter((Function & Serializable)r -> r.getSource().substring(0, 3).equals("20|")).count());
        result.filter((Function & Serializable)r -> r.getSource().substring(0, 3).equals("20|")).foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"isAuthorInstitutionOf", (Object)r.getRelClass()));
        Assertions.assertEquals((long)1L, (long)result.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).count());
        Assertions.assertEquals((long)1L, (long)result.filter((Function & Serializable)r -> r.getSource().equals("20|dedup_wf_001::2899e571609779168222fdeb59cb916d")).count());
        Assertions.assertEquals((long)2L, (long)result.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).count());
        Assertions.assertEquals((long)2L, (long)result.filter((Function & Serializable)r -> r.getSource().equals("20|openaire____::ec653e804967133b9436fdd30d3ff51d")).count());
        Assertions.assertEquals((long)3L, (long)result.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::03748bcb5d754c951efec9700e18a56d")).count());
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("50|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|doajarticles::1cae0b82b56ccd97c2db1f698def7074"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("50|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|openaire____::ec653e804967133b9436fdd30d3ff51d"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("50|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("50|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|doajarticles::03748bcb5d754c951efec9700e18a56d"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("50|dedup_wf_001::2899e571609779168222fdeb59cb916d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|dedup_wf_001::2899e571609779168222fdeb59cb916d"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("50|dedup_wf_001::2899e571609779168222fdeb59cb916d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("50|dedup_wf_001::2899e571609779168222fdeb59cb916d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|doajarticles::03748bcb5d754c951efec9700e18a56d"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("50|openaire____::ec653e804967133b9436fdd30d3ff51d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|openaire____::ec653e804967133b9436fdd30d3ff51d"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("50|doajarticles::03748bcb5d754c951efec9700e18a56d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|doajarticles::03748bcb5d754c951efec9700e18a56d"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("20|openaire____::ec653e804967133b9436fdd30d3ff51d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("50|doajarticles::1cae0b82b56ccd97c2db1f698def7074"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("20|openaire____::ec653e804967133b9436fdd30d3ff51d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("50|openaire____::ec653e804967133b9436fdd30d3ff51d"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).map((Function & Serializable)r -> r.getTarget()).collect().contains("50|dedup_wf_001::2899e571609779168222fdeb59cb916d"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).map((Function & Serializable)r -> r.getTarget()).collect().contains("50|doajarticles::2baa9032dc058d3c8ff780c426b0c19f"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::03748bcb5d754c951efec9700e18a56d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("50|dedup_wf_001::2899e571609779168222fdeb59cb916d"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::03748bcb5d754c951efec9700e18a56d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("50|doajarticles::2baa9032dc058d3c8ff780c426b0c19f"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::03748bcb5d754c951efec9700e18a56d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("50|doajarticles::03748bcb5d754c951efec9700e18a56d"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("20|dedup_wf_001::2899e571609779168222fdeb59cb916d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("50|dedup_wf_001::2899e571609779168222fdeb59cb916d"));
        Assertions.assertTrue((boolean)result.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).map((Function & Serializable)r -> r.getTarget()).collect().contains("50|doajarticles::1cae0b82b56ccd97c2db1f698def7074"));
    }

    @Test
    public void completeProjectExecution() throws Exception {
        String graphPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/graph").getPath();
        String leavesPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/currentIteration/").getPath();
        String childParentPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/childParentOrg/").getPath();
        String resultOrgPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/resultOrganization/").getPath();
        String projectOrgPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/projectOrganization/").getPath();
        PropagationConstant.readPath((SparkSession)spark, (String)leavesPath, Leaves.class).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(workingDir.toString() + "/leavesInput");
        PropagationConstant.readPath((SparkSession)spark, (String)resultOrgPath, KeyValueSet.class).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(workingDir.toString() + "/orgsInput");
        PropagationConstant.readPath((SparkSession)spark, (String)projectOrgPath, KeyValueSet.class).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(workingDir.toString() + "/projectInput");
        SparkEntityToOrganizationFromSemRel.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-relationPath", graphPath, "-hive_metastore_uris", "", "-outputPath", workingDir.toString() + "/finalrelation", "-leavesPath", workingDir.toString() + "/leavesInput", "-resultOrgPath", workingDir.toString() + "/orgsInput", "-projectOrganizationPath", workingDir.toString() + "/projectInput", "-childParentPath", childParentPath, "-workingDir", workingDir.toString()});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD temp = sc.textFile(workingDir.toString() + "/finalrelation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Assertions.assertEquals((long)36L, (long)temp.count());
        JavaRDD project = temp.filter((Function & Serializable)r -> r.getSource().startsWith("40|") || r.getTarget().startsWith("40|"));
        Assertions.assertEquals((long)18L, (long)project.count());
        project.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"participation", (Object)r.getSubRelType()));
        project.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"projectOrganization", (Object)r.getRelType()));
        project.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"propagation", (Object)r.getDataInfo().getInferenceprovenance()));
        project.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"project:organization:semrel", (Object)r.getDataInfo().getProvenanceaction().getClassid()));
        project.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"Propagation of participation to project through semantic relations", (Object)r.getDataInfo().getProvenanceaction().getClassname()));
        project.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"0.85", (Object)r.getDataInfo().getTrust()));
        Assertions.assertEquals((long)9L, (long)project.filter((Function & Serializable)r -> r.getSource().substring(0, 3).equals("40|")).count());
        project.filter((Function & Serializable)r -> r.getSource().substring(0, 3).equals("40|")).foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"hasParticipant", (Object)r.getRelClass()));
        Assertions.assertEquals((long)2L, (long)project.filter((Function & Serializable)r -> r.getSource().equals("40|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).count());
        Assertions.assertEquals((long)3L, (long)project.filter((Function & Serializable)r -> r.getSource().equals("40|dedup_wf_001::2899e571609779168222fdeb59cb916d")).count());
        Assertions.assertEquals((long)2L, (long)project.filter((Function & Serializable)r -> r.getSource().equals("40|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).count());
        Assertions.assertEquals((long)1L, (long)project.filter((Function & Serializable)r -> r.getSource().equals("40|openaire____::ec653e804967133b9436fdd30d3ff51d")).count());
        Assertions.assertEquals((long)1L, (long)project.filter((Function & Serializable)r -> r.getSource().equals("40|doajarticles::03748bcb5d754c951efec9700e18a56d")).count());
        Assertions.assertEquals((long)9L, (long)project.filter((Function & Serializable)r -> r.getSource().substring(0, 3).equals("20|")).count());
        project.filter((Function & Serializable)r -> r.getSource().substring(0, 3).equals("20|")).foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"isParticipant", (Object)r.getRelClass()));
        Assertions.assertEquals((long)1L, (long)project.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).count());
        Assertions.assertEquals((long)1L, (long)project.filter((Function & Serializable)r -> r.getSource().equals("20|dedup_wf_001::2899e571609779168222fdeb59cb916d")).count());
        Assertions.assertEquals((long)2L, (long)project.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).count());
        Assertions.assertEquals((long)2L, (long)project.filter((Function & Serializable)r -> r.getSource().equals("20|openaire____::ec653e804967133b9436fdd30d3ff51d")).count());
        Assertions.assertEquals((long)3L, (long)project.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::03748bcb5d754c951efec9700e18a56d")).count());
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("40|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|doajarticles::1cae0b82b56ccd97c2db1f698def7074"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("40|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|openaire____::ec653e804967133b9436fdd30d3ff51d"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("40|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("40|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|doajarticles::03748bcb5d754c951efec9700e18a56d"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("40|dedup_wf_001::2899e571609779168222fdeb59cb916d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|dedup_wf_001::2899e571609779168222fdeb59cb916d"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("40|dedup_wf_001::2899e571609779168222fdeb59cb916d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("40|dedup_wf_001::2899e571609779168222fdeb59cb916d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|doajarticles::03748bcb5d754c951efec9700e18a56d"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("40|openaire____::ec653e804967133b9436fdd30d3ff51d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|openaire____::ec653e804967133b9436fdd30d3ff51d"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("40|doajarticles::03748bcb5d754c951efec9700e18a56d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("20|doajarticles::03748bcb5d754c951efec9700e18a56d"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("20|openaire____::ec653e804967133b9436fdd30d3ff51d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("40|doajarticles::1cae0b82b56ccd97c2db1f698def7074"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("20|openaire____::ec653e804967133b9436fdd30d3ff51d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("40|openaire____::ec653e804967133b9436fdd30d3ff51d"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).map((Function & Serializable)r -> r.getTarget()).collect().contains("40|dedup_wf_001::2899e571609779168222fdeb59cb916d"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).map((Function & Serializable)r -> r.getTarget()).collect().contains("40|doajarticles::2baa9032dc058d3c8ff780c426b0c19f"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::03748bcb5d754c951efec9700e18a56d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("40|dedup_wf_001::2899e571609779168222fdeb59cb916d"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::03748bcb5d754c951efec9700e18a56d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("40|doajarticles::2baa9032dc058d3c8ff780c426b0c19f"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::03748bcb5d754c951efec9700e18a56d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("40|doajarticles::03748bcb5d754c951efec9700e18a56d"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("20|dedup_wf_001::2899e571609779168222fdeb59cb916d")).map((Function & Serializable)r -> r.getTarget()).collect().contains("40|dedup_wf_001::2899e571609779168222fdeb59cb916d"));
        Assertions.assertTrue((boolean)project.filter((Function & Serializable)r -> r.getSource().equals("20|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).map((Function & Serializable)r -> r.getTarget()).collect().contains("40|doajarticles::1cae0b82b56ccd97c2db1f698def7074"));
    }

    @Test
    public void singleIterationExecution() throws Exception {
        String graphPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/graph").getPath();
        String leavesPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/currentIteration/").getPath();
        String childParentPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/childParentOrg/").getPath();
        String resultOrgPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/resultOrganization/").getPath();
        String projectOrgPath = this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/projectOrganization/").getPath();
        PropagationConstant.readPath((SparkSession)spark, (String)leavesPath, Leaves.class).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(workingDir.toString() + "/leavesInput");
        PropagationConstant.readPath((SparkSession)spark, (String)resultOrgPath, KeyValueSet.class).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(workingDir.toString() + "/orgsInput");
        PropagationConstant.readPath((SparkSession)spark, (String)projectOrgPath, KeyValueSet.class).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(workingDir.toString() + "/projectInput");
        SparkEntityToOrganizationFromSemRel.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-relationPath", graphPath, "-hive_metastore_uris", "", "-outputPath", workingDir.toString() + "/finalrelation", "-leavesPath", workingDir.toString() + "/leavesInput", "-resultOrgPath", workingDir.toString() + "/orgsInput", "-projectOrganizationPath", workingDir.toString() + "/projectInput", "-childParentPath", childParentPath, "-workingDir", workingDir.toString(), "-iterations", "1"});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD temp = sc.textFile(workingDir.toString() + "/finalrelation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Assertions.assertEquals((long)16L, (long)temp.count());
        Assertions.assertEquals((long)4L, (long)temp.filter((Function & Serializable)r -> r.getSource().startsWith("50|")).count());
        Assertions.assertEquals((long)4L, (long)temp.filter((Function & Serializable)r -> r.getTarget().startsWith("50|")).count());
        Assertions.assertEquals((long)4L, (long)temp.filter((Function & Serializable)r -> r.getSource().startsWith("40|")).count());
        Assertions.assertEquals((long)4L, (long)temp.filter((Function & Serializable)r -> r.getTarget().startsWith("40|")).count());
        Assertions.assertEquals((long)8L, (long)temp.filter((Function & Serializable)r -> r.getSource().startsWith("20|")).count());
        Assertions.assertEquals((long)8L, (long)temp.filter((Function & Serializable)r -> r.getSource().startsWith("20|")).count());
    }

    static {
        log = LoggerFactory.getLogger(SparkJobTest.class);
    }
}

