/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.resulttocommunityfromsemrel;

import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.api.Utils;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.resulttocommunityfromorganization.ResultCommunityList;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareResultCommunitySetStep1 {
    private static final Logger log = LoggerFactory.getLogger(PrepareResultCommunitySetStep1.class);
    private static final String RESULT_CONTEXT_QUERY_TEMPLATE = "select target resultId, community_context  from (select id, collect_set(co.id) community_context        from  result        lateral view explode (context) c as co        where datainfo.deletedbyinference = false %s group by id) p  JOIN  (select source, target from relation   where datainfo.deletedbyinference = false %s ) r ON p.id = r.source";
    private static final String RESULT_COMMUNITY_LIST_QUERY = "select resultId , collect_set(co) communityList from result_context lateral view explode (community_context) c as co where length(co) > 0 group by resultId";
    private static final String RESULT_CONTEXT_QUERY_TEMPLATE_IS_RELATED_TO = "select target as resultId, community_context from resultWithContext rwc join relatedToRelations r join patents p  on rwc.id = r.source and r.target = p.id";
    private static final String RESULT_WITH_CONTEXT = "select id, collect_set(co.id) community_context        \n    from  result            lateral view explode (context) c as co         where  lower(co.id) IN %s    group by id";
    private static final String RESULT_PATENT = "select id     from result     where array_contains(instance.instancetype.classname, 'Patent')";
    private static final String IS_RELATED_TO_RELATIONS = "select source, target     from relation     where lower(relClass) = 'isrelatedto' and datainfo.deletedbyinference = false";

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareResultCommunitySetStep1.class.getResourceAsStream("/eu/dnetlib/dhp/wf/subworkflows/resulttocommunityfromsemrel/input_preparecommunitytoresult_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String resultClassName = parser.get("resultTableName");
        log.info("resultTableName: {}", (Object)resultClassName);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", parser.get("hive_metastore_uris"));
        String allowedsemrel = "(" + String.join((CharSequence)",", (CharSequence[])Arrays.asList(parser.get("allowedsemrels").split(";")).stream().map(value -> "'" + value.toLowerCase() + "'").toArray(String[]::new)) + ")";
        log.info("allowedSemRel: {}", (Object)allowedsemrel);
        String baseURL = parser.get("baseURL");
        log.info("baseURL: {}", (Object)baseURL);
        String communityIdList = "(" + String.join((CharSequence)",", (CharSequence[])PrepareResultCommunitySetStep1.getCommunityList(baseURL).stream().map(value -> "'" + value.toLowerCase() + "'").toArray(String[]::new)) + ")";
        String resultType = resultClassName.substring(resultClassName.lastIndexOf(".") + 1).toLowerCase();
        log.info("resultType: {}", (Object)resultType);
        Class<?> resultClazz = Class.forName(resultClassName);
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            if (PropagationConstant.isTest(parser).booleanValue()) {
                PropagationConstant.removeOutputDir(spark, outputPath);
            }
            PrepareResultCommunitySetStep1.prepareInfo(spark, inputPath, outputPath, allowedsemrel, resultClazz, resultType, communityIdList);
        });
    }

    private static <R extends Result> void prepareInfo(SparkSession spark, String inputPath, String outputPath, String allowedsemrel, Class<R> resultClazz, String resultType, String communityIdList) {
        String inputResultPath = inputPath + "/" + resultType;
        log.info("Reading Graph table from: {}", (Object)inputResultPath);
        String inputRelationPath = inputPath + "/relation";
        log.info("Reading relation table from: {}", (Object)inputResultPath);
        Dataset<Relation> relation = PropagationConstant.readPath(spark, inputRelationPath, Relation.class);
        relation.createOrReplaceTempView("relation");
        Dataset result = PropagationConstant.readPath(spark, inputResultPath, resultClazz).where("datainfo.deletedbyinference != true AND datainfo.invisible != true");
        result.createOrReplaceTempView("result");
        String outputResultPath = outputPath + "/" + resultType;
        log.info("writing output results to: {}", (Object)outputResultPath);
        String resultContextQuery = String.format(RESULT_CONTEXT_QUERY_TEMPLATE, "AND  lower(co.id) IN " + communityIdList, "AND lower(relClass) IN " + allowedsemrel);
        Dataset result_context = spark.sql(resultContextQuery);
        Dataset rwc = spark.sql(String.format(RESULT_WITH_CONTEXT, communityIdList));
        Dataset patents = spark.sql(RESULT_PATENT);
        Dataset relatedToRelations = spark.sql(IS_RELATED_TO_RELATIONS);
        rwc.createOrReplaceTempView("resultWithContext");
        patents.createOrReplaceTempView("patents");
        relatedToRelations.createOrReplaceTempView("relatedTorelations");
        result_context = result_context.unionAll(spark.sql(RESULT_CONTEXT_QUERY_TEMPLATE_IS_RELATED_TO));
        result_context.createOrReplaceTempView("result_context");
        spark.sql(RESULT_COMMUNITY_LIST_QUERY).as(Encoders.bean(ResultCommunityList.class)).write().option("compression", "gzip").mode(SaveMode.Append).json(outputResultPath);
    }

    public static List<String> getCommunityList(String baseURL) throws IOException {
        return Utils.getCommunityIdList(baseURL);
    }
}

