/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp;

import eu.dnetlib.dhp.PropagationConstant;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveResult
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MoveResult.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)MoveResult.class.getResourceAsStream("/eu/dnetlib/dhp/wf/subworkflows/input_moveresult_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = PropagationConstant.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> MoveResult.moveResults(spark, inputPath, outputPath));
    }

    public static <R extends Result> void moveResults(SparkSession spark, String inputPath, String outputPath) {
        ModelSupport.entityTypes.keySet().parallelStream().filter(e -> ModelSupport.isResult((EntityType)e)).forEach(e -> {
            Class resultClazz = (Class)ModelSupport.entityTypes.get(e);
            Dataset resultDataset = PropagationConstant.readPath(spark, inputPath + e.name(), resultClazz);
            if (resultDataset.count() > 0L) {
                resultDataset.write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath + e.name());
            }
        });
    }
}

