/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.countrypropagation;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.countrypropagation.CountrySbs;
import eu.dnetlib.dhp.countrypropagation.PrepareResultCountrySet;
import eu.dnetlib.dhp.countrypropagation.ResultCountrySet;
import eu.dnetlib.dhp.schema.oaf.Publication;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ResultCountryPreparationTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(ResultCountryPreparationTest.class.getSimpleName(), new FileAttribute[0]);
        SparkConf conf = new SparkConf();
        conf.setAppName(ResultCountryPreparationTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(ResultCountryPreparationTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testPrepareResultCountry() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/countrypropagation/graph/publication").getPath();
        String preparedInfoPath = this.getClass().getResource("/eu/dnetlib/dhp/countrypropagation/datasourcecountry").getPath();
        PrepareResultCountrySet.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--workingPath", workingDir.toString() + "/working", "--sourcePath", sourcePath, "--outputPath", workingDir.toString() + "/resultCountry", "--preparedInfoPath", preparedInfoPath, "--resultTableName", Publication.class.getCanonicalName()});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/resultCountry").map((Function & Serializable)item -> (ResultCountrySet)OBJECT_MAPPER.readValue(item, ResultCountrySet.class));
        Assertions.assertEquals((long)5L, (long)tmp.count());
        ResultCountrySet rc = (ResultCountrySet)tmp.filter((Function & Serializable)r -> r.getResultId().equals("50|06cdd3ff4700::49ec404cee4e1452808aabeaffbd3072")).collect().get(0);
        Assertions.assertEquals((int)1, (int)rc.getCountrySet().size());
        Assertions.assertEquals((Object)"NL", (Object)((CountrySbs)rc.getCountrySet().get(0)).getClassid());
        Assertions.assertEquals((Object)"Netherlands", (Object)((CountrySbs)rc.getCountrySet().get(0)).getClassname());
        rc = (ResultCountrySet)tmp.filter((Function & Serializable)r -> r.getResultId().equals("50|07b5c0ccd4fe::e7f5459cc97865f2af6e3da964c1250b")).collect().get(0);
        Assertions.assertEquals((int)1, (int)rc.getCountrySet().size());
        Assertions.assertEquals((Object)"NL", (Object)((CountrySbs)rc.getCountrySet().get(0)).getClassid());
        Assertions.assertEquals((Object)"Netherlands", (Object)((CountrySbs)rc.getCountrySet().get(0)).getClassname());
        rc = (ResultCountrySet)tmp.filter((Function & Serializable)r -> r.getResultId().equals("50|355e65625b88::e7d48a470b13bda61f7ebe3513e20cb6")).collect().get(0);
        Assertions.assertEquals((int)2, (int)rc.getCountrySet().size());
        Assertions.assertTrue((boolean)rc.getCountrySet().stream().anyMatch(cs -> cs.getClassid().equals("IT") && cs.getClassname().equals("Italy")));
        Assertions.assertTrue((boolean)rc.getCountrySet().stream().anyMatch(cs -> cs.getClassid().equals("FR") && cs.getClassname().equals("France")));
        rc = (ResultCountrySet)tmp.filter((Function & Serializable)r -> r.getResultId().equals("50|355e65625b88::74009c567c81b4aa55c813db658734df")).collect().get(0);
        Assertions.assertEquals((int)2, (int)rc.getCountrySet().size());
        Assertions.assertTrue((boolean)rc.getCountrySet().stream().anyMatch(cs -> cs.getClassid().equals("IT") && cs.getClassname().equals("Italy")));
        Assertions.assertTrue((boolean)rc.getCountrySet().stream().anyMatch(cs -> cs.getClassid().equals("NL") && cs.getClassname().equals("Netherlands")));
        rc = (ResultCountrySet)tmp.filter((Function & Serializable)r -> r.getResultId().equals("50|355e65625b88::54a1c76f520bb2c8da27d12e42891088")).collect().get(0);
        Assertions.assertEquals((int)2, (int)rc.getCountrySet().size());
        Assertions.assertTrue((boolean)rc.getCountrySet().stream().anyMatch(cs -> cs.getClassid().equals("IT") && cs.getClassname().equals("Italy")));
        Assertions.assertTrue((boolean)rc.getCountrySet().stream().anyMatch(cs -> cs.getClassid().equals("FR") && cs.getClassname().equals("France")));
    }
}

