/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.person;

import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Measure;
import eu.dnetlib.dhp.schema.oaf.Person;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.Serializable;
import java.util.List;

public class OrcidIndicators
implements Serializable {
    private String resultId;
    private String orcid;
    private Integer downloads;
    private Integer citations;
    private static final String PERSON_PREFIX = ModelSupport.getIdPrefix(Person.class) + "|" + "orcid" + "_______";

    public static OrcidIndicators newInstance(String id, String orcid, List<Measure> measures) {
        OrcidIndicators oi = new OrcidIndicators();
        oi.resultId = id;
        oi.orcid = DHPUtils.generateIdentifier((String)orcid, (String)PERSON_PREFIX);
        oi.downloads = measures.stream().filter(m -> m.getId().equalsIgnoreCase("downloads")).findFirst().map(m -> Integer.parseInt(((KeyValue)m.getUnit().get(0)).getValue())).orElse(0);
        oi.citations = measures.stream().filter(m -> m.getId().equalsIgnoreCase("influence_alt")).findFirst().map(m -> m.getUnit().stream().filter(u -> u.getKey().equals("score")).findFirst().map(u -> Integer.parseInt(u.getValue())).orElse(0)).orElse(0);
        return oi;
    }

    public String getOrcid() {
        return this.orcid;
    }

    public void setOrcid(String orcid) {
        this.orcid = orcid;
    }

    public Integer getDownloads() {
        return this.downloads;
    }

    public void setDownloads(Integer downloads) {
        this.downloads = downloads;
    }

    public String getResultId() {
        return this.resultId;
    }

    public void setResultId(String resultId) {
        this.resultId = resultId;
    }

    public void addIndicators(Integer downloads, Integer citations) {
        this.downloads = this.downloads + downloads;
        this.citations = this.citations + citations;
    }

    public void setCitations(Integer citations) {
        this.citations = citations;
    }

    public Integer getCitations() {
        return this.citations;
    }
}

