/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.entitytoorganizationfromsemrel;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.KeyValueSet;
import eu.dnetlib.dhp.entitytoorganizationfromsemrel.Leaves;
import eu.dnetlib.dhp.entitytoorganizationfromsemrel.PrepareInfoJobTest;
import eu.dnetlib.dhp.entitytoorganizationfromsemrel.StepActions;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.ForeachFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepActionsTest {
    private static final Logger log = LoggerFactory.getLogger(StepActionsTest.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(StepActionsTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(PrepareInfoJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PrepareInfoJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    public void execStepTest() {
        StepActions.execStep((SparkSession)spark, (String)this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/graph/result").getPath(), (String)(workingDir.toString() + "/newRelationPath"), (String)this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/currentIteration/").getPath(), (String)this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/childParentOrg/").getPath(), (String)this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/resultOrganization/").getPath(), (String)"hasAuthorInstitution");
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/newRelationPath").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Assertions.assertEquals((long)4L, (long)tmp.count());
        Dataset verificationDs = spark.createDataset(tmp.rdd(), Encoders.bean(Relation.class));
        verificationDs.foreach((ForeachFunction & Serializable)r -> Assertions.assertEquals((Object)"propagation", (Object)r.getDataInfo().getInferenceprovenance()));
        verificationDs.foreach((ForeachFunction & Serializable)r -> Assertions.assertEquals((Object)"0.85", (Object)r.getDataInfo().getTrust()));
        verificationDs.foreach((ForeachFunction & Serializable)r -> Assertions.assertEquals((Object)"50|", (Object)r.getSource().substring(0, 3)));
        verificationDs.foreach((ForeachFunction & Serializable)r -> Assertions.assertEquals((Object)"20|", (Object)r.getTarget().substring(0, 3)));
        verificationDs.foreach((ForeachFunction & Serializable)r -> Assertions.assertEquals((Object)"hasAuthorInstitution", (Object)r.getRelClass()));
        verificationDs.foreach((ForeachFunction & Serializable)r -> Assertions.assertEquals((Object)"resultOrganization", (Object)r.getRelType()));
        verificationDs.foreach((ForeachFunction & Serializable)r -> Assertions.assertEquals((Object)"affiliation", (Object)r.getSubRelType()));
        verificationDs.foreach((ForeachFunction & Serializable)r -> Assertions.assertEquals((Object)"result:organization:semrel", (Object)r.getDataInfo().getProvenanceaction().getClassid()));
        verificationDs.foreach((ForeachFunction & Serializable)r -> Assertions.assertEquals((Object)"Propagation of affiliation to result through semantic relations", (Object)r.getDataInfo().getProvenanceaction().getClassname()));
        verificationDs.filter((FilterFunction & Serializable)r -> r.getSource().equals("50|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).foreach((ForeachFunction & Serializable)r -> Assertions.assertEquals((Object)"20|doajarticles::1cae0b82b56ccd97c2db1f698def7074", (Object)r.getTarget()));
        verificationDs.filter((FilterFunction & Serializable)r -> r.getSource().equals("50|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).foreach((ForeachFunction & Serializable)r -> Assertions.assertEquals((Object)"20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f", (Object)r.getTarget()));
        Assertions.assertEquals((long)2L, (long)verificationDs.filter((FilterFunction & Serializable)r -> r.getSource().equals("50|dedup_wf_001::2899e571609779168222fdeb59cb916d")).count());
        Assertions.assertEquals((long)1L, (long)verificationDs.filter((FilterFunction & Serializable)r -> r.getSource().equals("50|dedup_wf_001::2899e571609779168222fdeb59cb916d") && r.getTarget().equals("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).count());
        Assertions.assertEquals((long)1L, (long)verificationDs.filter((FilterFunction & Serializable)r -> r.getSource().equals("50|dedup_wf_001::2899e571609779168222fdeb59cb916d") && r.getTarget().equals("20|dedup_wf_001::2899e571609779168222fdeb59cb916d")).count());
        tmp.foreach((VoidFunction & Serializable)r -> System.out.println(OBJECT_MAPPER.writeValueAsString(r)));
    }

    @Test
    public void prepareForNextStepLeavesTest() {
        StepActions.prepareForNextStep((SparkSession)spark, (String)this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/relsforiteration1/").getPath(), (String)this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/resultOrganization/").getPath(), (String)this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/currentIteration/").getPath(), (String)this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/childParentOrg/").getPath(), (String)(workingDir.toString() + "/tempLeaves"), (String)(workingDir.toString() + "/tempOrgs"));
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/tempLeaves").map((Function & Serializable)item -> (Leaves)OBJECT_MAPPER.readValue(item, Leaves.class));
        Assertions.assertEquals((long)3L, (long)tmp.count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)l -> l.getValue().equals("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)l -> l.getValue().equals("20|dedup_wf_001::2899e571609779168222fdeb59cb916d")).count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)l -> l.getValue().equals("20|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).count());
    }

    @Test
    public void prepareFonNextStepOrgTest() {
        StepActions.prepareForNextStep((SparkSession)spark, (String)this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/relsforiteration1/").getPath(), (String)this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/resultOrganization/").getPath(), (String)this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/currentIteration/").getPath(), (String)this.getClass().getResource("/eu/dnetlib/dhp/entitytoorganizationfromsemrel/execstep/childParentOrg/").getPath(), (String)(workingDir.toString() + "/tempLeaves"), (String)(workingDir.toString() + "/tempOrgs"));
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/tempOrgs").map((Function & Serializable)item -> (KeyValueSet)OBJECT_MAPPER.readValue(item, KeyValueSet.class));
        Assertions.assertEquals((long)5L, (long)tmp.count());
        Assertions.assertEquals((int)1, (int)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|openaire____::ec653e804967133b9436fdd30d3ff51d")).collect().get(0)).getValueSet().size());
        Assertions.assertEquals((Object)"20|doajarticles::1cae0b82b56ccd97c2db1f698def7074", ((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|openaire____::ec653e804967133b9436fdd30d3ff51d")).collect().get(0)).getValueSet().get(0));
        Assertions.assertEquals((int)1, (int)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|doajarticles::03748bcb5d754c951efec9700e18a56d")).collect().get(0)).getValueSet().size());
        Assertions.assertEquals((Object)"20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f", ((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|doajarticles::03748bcb5d754c951efec9700e18a56d")).collect().get(0)).getValueSet().get(0));
        Assertions.assertEquals((int)4, (int)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|dedup_wf_001::2899e571609779168222fdeb59cb916d")).collect().get(0)).getValueSet().size());
        Assertions.assertTrue((boolean)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|dedup_wf_001::2899e571609779168222fdeb59cb916d")).collect().get(0)).getValueSet().contains("20|dedup_wf_001::2899e571609779168222fdeb59cb916d"));
        Assertions.assertTrue((boolean)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|dedup_wf_001::2899e571609779168222fdeb59cb916d")).collect().get(0)).getValueSet().contains("20|doajarticles::396262ee936f3d3e26ff0e60bea6cae0"));
        Assertions.assertTrue((boolean)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|dedup_wf_001::2899e571609779168222fdeb59cb916d")).collect().get(0)).getValueSet().contains("20|pippo_wf_001::2899e571609779168222fdeb59cb916d"));
        Assertions.assertTrue((boolean)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|dedup_wf_001::2899e571609779168222fdeb59cb916d")).collect().get(0)).getValueSet().contains("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f"));
        Assertions.assertEquals((int)2, (int)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).collect().get(0)).getValueSet().size());
        Assertions.assertTrue((boolean)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).collect().get(0)).getValueSet().contains("20|opendoar____::a5fcb8eb25ebd6f7cd219e0fa1e6ddc1"));
        Assertions.assertTrue((boolean)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|doajarticles::1cae0b82b56ccd97c2db1f698def7074")).collect().get(0)).getValueSet().contains("20|doajarticles::1cae0b82b56ccd97c2db1f698def7074"));
        Assertions.assertEquals((int)3, (int)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).collect().get(0)).getValueSet().size());
        Assertions.assertTrue((boolean)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).collect().get(0)).getValueSet().contains("20|dedup_wf_001::2899e571609779168222fdeb59cb916d"));
        Assertions.assertTrue((boolean)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).collect().get(0)).getValueSet().contains("20|pippo_wf_001::2899e571609779168222fdeb59cb916d"));
        Assertions.assertTrue((boolean)((KeyValueSet)tmp.filter((Function & Serializable)kv -> kv.getKey().equals("50|doajarticles::2baa9032dc058d3c8ff780c426b0c19f")).collect().get(0)).getValueSet().contains("20|doajarticles::2baa9032dc058d3c8ff780c426b0c19f"));
    }
}

