/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.oa.graph.raw.common.RelationIdMapping;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchRelationsApplication {
    private static final Logger log = LoggerFactory.getLogger(PatchRelationsApplication.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Optional.ofNullable(PatchRelationsApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/patch_relations_parameters.json")).orElseThrow(FileNotFoundException::new)));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String graphBasePath = parser.get("graphBasePath");
        log.info("graphBasePath: {}", (Object)graphBasePath);
        String workingDir = parser.get("workingDir");
        log.info("workingDir: {}", (Object)workingDir);
        String idMappingPath = parser.get("idMappingPath");
        log.info("idMappingPath: {}", (Object)idMappingPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> PatchRelationsApplication.patchRelations(spark, graphBasePath, workingDir, idMappingPath));
    }

    private static void patchRelations(SparkSession spark, String graphBasePath, String workingDir, String idMappingPath) {
        String relationPath = graphBasePath + "/relation";
        Dataset<Relation> rels = PatchRelationsApplication.readPath(spark, relationPath, Relation.class);
        Dataset<RelationIdMapping> idMapping = PatchRelationsApplication.readPath(spark, idMappingPath, RelationIdMapping.class);
        log.info("relations: {}", (Object)rels.count());
        log.info("idMapping: {}", (Object)idMapping.count());
        Dataset bySource = rels.joinWith(idMapping, rels.col("source").equalTo((Object)idMapping.col("oldId")), "left").map((MapFunction & Serializable)t -> {
            Relation r = (Relation)t._1();
            Optional.ofNullable(t._2()).map(RelationIdMapping::getNewId).ifPresent(arg_0 -> ((Relation)r).setSource(arg_0));
            return r;
        }, Encoders.bean(Relation.class));
        bySource.joinWith(idMapping, bySource.col("target").equalTo((Object)idMapping.col("oldId")), "left").map((MapFunction & Serializable)t -> {
            Relation r = (Relation)t._1();
            Optional.ofNullable(t._2()).map(RelationIdMapping::getNewId).ifPresent(arg_0 -> ((Relation)r).setTarget(arg_0));
            return r;
        }, Encoders.bean(Relation.class)).map(arg_0 -> ((ObjectMapper)OBJECT_MAPPER).writeValueAsString(arg_0), Encoders.STRING()).write().mode(SaveMode.Overwrite).option("compression", "gzip").text(workingDir);
        spark.read().textFile(workingDir).write().mode(SaveMode.Overwrite).option("compression", "gzip").text(relationPath);
    }

    public static <R> Dataset<R> readPath(SparkSession spark, String inputPath, Class<R> clazz) {
        return spark.read().textFile(inputPath).map((MapFunction & Serializable)value -> OBJECT_MAPPER.readValue(value, clazz), Encoders.bean(clazz));
    }
}

