/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.clean;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.oa.graph.clean.CleaningRuleMap;
import eu.dnetlib.dhp.oa.graph.clean.OafCleaner;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Country;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Subject;
import eu.dnetlib.dhp.schema.oaf.utils.GraphCleaningFunctions;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class GraphCleaningFunctionsTest {
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    @Mock
    private ISLookUpService isLookUpService;
    private VocabularyGroup vocabularies;
    private CleaningRuleMap mapping;

    @BeforeEach
    public void setUp() throws ISLookUpException, IOException {
        Mockito.lenient().when((Object)this.isLookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType') \nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nreturn concat($vocid,' @=@ ',$vocname,' @=@ ',$term/@code,' @=@ ',$term/@english_name)")).thenReturn(this.vocs());
        Mockito.lenient().when((Object)this.isLookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')\nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nfor $syn in ($term//SYNONYM/@term)\nreturn concat($vocid,' @=@ ',$term/@code,' @=@ ', $syn)\n")).thenReturn(this.synonyms());
        this.vocabularies = VocabularyGroup.loadVocsFromIS((ISLookUpService)this.isLookUpService);
        this.mapping = CleaningRuleMap.create((VocabularyGroup)this.vocabularies);
    }

    @Test
    void testCleanRelations() throws Exception {
        List lines = IOUtils.readLines((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/graph/relation/relation.json"));
        for (String json : lines) {
            Relation r_in = (Relation)MAPPER.readValue(json, Relation.class);
            Assertions.assertNotNull((Object)r_in);
            Assertions.assertFalse((boolean)this.vocabularies.getTerms("dnet:relation_relClass").contains(r_in.getRelClass()));
            Relation r_out = (Relation)OafCleaner.apply((Oaf)r_in, (CleaningRuleMap)this.mapping);
            Assertions.assertTrue((boolean)this.vocabularies.getTerms("dnet:relation_relClass").contains(r_out.getRelClass()));
            Assertions.assertTrue((boolean)this.vocabularies.getTerms("dnet:relation_subRelType").contains(r_out.getSubRelType()));
            Assertions.assertEquals((Object)"iis", (Object)r_out.getDataInfo().getProvenanceaction().getClassid());
            Assertions.assertEquals((Object)"Inferred by OpenAIRE", (Object)r_out.getDataInfo().getProvenanceaction().getClassname());
        }
    }

    @Test
    void testFilter_invisible_true() throws Exception {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertNotNull((Object)this.mapping);
        String json = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/result_invisible.json"));
        Publication p_in = (Publication)MAPPER.readValue(json, Publication.class);
        Assertions.assertTrue((boolean)(p_in instanceof Result));
        Assertions.assertTrue((boolean)(p_in instanceof Publication));
        Assertions.assertEquals((Object)true, (Object)GraphCleaningFunctions.filter((Oaf)p_in));
    }

    @Test
    void testFilter_true_nothing_to_filter() throws Exception {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertNotNull((Object)this.mapping);
        String json = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/result.json"));
        Publication p_in = (Publication)MAPPER.readValue(json, Publication.class);
        Assertions.assertTrue((boolean)(p_in instanceof Result));
        Assertions.assertTrue((boolean)(p_in instanceof Publication));
        Assertions.assertEquals((Object)true, (Object)GraphCleaningFunctions.filter((Oaf)p_in));
    }

    @Test
    void testFilter_missing_invisible() throws Exception {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertNotNull((Object)this.mapping);
        String json = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/result_missing_invisible.json"));
        Publication p_in = (Publication)MAPPER.readValue(json, Publication.class);
        Assertions.assertTrue((boolean)(p_in instanceof Result));
        Assertions.assertTrue((boolean)(p_in instanceof Publication));
        Assertions.assertEquals((Object)true, (Object)GraphCleaningFunctions.filter((Oaf)p_in));
    }

    @Test
    void testCleaning() throws Exception {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertNotNull((Object)this.mapping);
        String json = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/result.json"));
        Publication p_in = (Publication)MAPPER.readValue(json, Publication.class);
        Assertions.assertNull((Object)p_in.getBestaccessright());
        Assertions.assertTrue((boolean)(p_in instanceof Result));
        Assertions.assertTrue((boolean)(p_in instanceof Publication));
        Publication p_out = (Publication)OafCleaner.apply((Oaf)GraphCleaningFunctions.fixVocabularyNames((Oaf)p_in), (CleaningRuleMap)this.mapping);
        Assertions.assertNotNull((Object)p_out);
        Assertions.assertNotNull((Object)p_out.getPublisher());
        Assertions.assertNull((Object)p_out.getPublisher().getValue());
        Assertions.assertEquals((Object)"und", (Object)p_out.getLanguage().getClassid());
        Assertions.assertEquals((Object)"Undetermined", (Object)p_out.getLanguage().getClassname());
        Assertions.assertEquals((Object)"DE", (Object)((Country)p_out.getCountry().get(0)).getClassid());
        Assertions.assertEquals((Object)"Germany", (Object)((Country)p_out.getCountry().get(0)).getClassname());
        Assertions.assertEquals((Object)"0018", (Object)((Instance)p_out.getInstance().get(0)).getInstancetype().getClassid());
        Assertions.assertEquals((Object)"Annotation", (Object)((Instance)p_out.getInstance().get(0)).getInstancetype().getClassname());
        Assertions.assertEquals((Object)"0027", (Object)((Instance)p_out.getInstance().get(1)).getInstancetype().getClassid());
        Assertions.assertEquals((Object)"Model", (Object)((Instance)p_out.getInstance().get(1)).getInstancetype().getClassname());
        Assertions.assertEquals((Object)"xyz", (Object)((Instance)p_out.getInstance().get(2)).getInstancetype().getClassid());
        Assertions.assertEquals((Object)"xyz", (Object)((Instance)p_out.getInstance().get(2)).getInstancetype().getClassname());
        Assertions.assertEquals((Object)"CLOSED", (Object)((Instance)p_out.getInstance().get(0)).getAccessright().getClassid());
        Assertions.assertEquals((Object)"Closed Access", (Object)((Instance)p_out.getInstance().get(0)).getAccessright().getClassname());
        Set pidTerms = this.vocabularies.getTerms("dnet:pid_types");
        Assertions.assertTrue((boolean)p_out.getPid().stream().map(StructuredProperty::getQualifier).allMatch(q -> pidTerms.contains(q.getClassid())));
        List poi = p_out.getInstance();
        Assertions.assertNotNull((Object)poi);
        Assertions.assertEquals((int)3, (int)poi.size());
        Instance poii = (Instance)poi.get(0);
        Assertions.assertNotNull((Object)poii);
        Assertions.assertNotNull((Object)poii.getPid());
        Assertions.assertEquals((int)2, (int)poii.getPid().size());
        Assertions.assertTrue((boolean)poii.getPid().stream().anyMatch(s -> s.getValue().equals("10.1007/s109090161569x")));
        Assertions.assertTrue((boolean)poii.getPid().stream().anyMatch(s -> s.getValue().equals("10.1008/abcd")));
        Assertions.assertNotNull((Object)poii.getAlternateIdentifier());
        Assertions.assertEquals((int)2, (int)poii.getAlternateIdentifier().size());
        Assertions.assertTrue((boolean)poii.getAlternateIdentifier().stream().anyMatch(s -> s.getValue().equals("10.1007/s109090161569x")));
        Assertions.assertTrue((boolean)poii.getAlternateIdentifier().stream().anyMatch(s -> s.getValue().equals("10.1009/qwerty")));
        Assertions.assertEquals((int)5, (int)p_out.getTitle().size());
        Publication p_cleaned = (Publication)GraphCleaningFunctions.cleanup((Oaf)p_out, (VocabularyGroup)this.vocabularies);
        Assertions.assertEquals((int)3, (int)p_cleaned.getTitle().size());
        List titles = p_cleaned.getTitle().stream().map(StructuredProperty::getValue).collect(Collectors.toList());
        Assertions.assertTrue((boolean)titles.contains("omic"));
        Assertions.assertTrue((boolean)titles.contains("Optical response of strained- and unstrained-silicon cold-electron bolometers test"));
        Assertions.assertTrue((boolean)titles.contains("\uff62\u30de\u30ad\u30e3\u30d9\u30ea\u7684\u77e5\u6027\u3068\u5fc3\u306e\u7406\u8ad6\u306e\u9032\u5316\u8ad6\uff63 \u30ea\u30c1\u30e3\u30fc\u30c9\u30fb\u30d0\u30fc\u30f3\uff0c \u30a2\u30f3\u30c9\u30ea\u30e5\u30fc\u30fb\u30db\u30ef\u30a4\u30c8\u30a5\u30f3 \u7de8\uff0f\u85e4\u7530\u548c\u751f\uff0c \u5c71\u4e0b\u535a\u5fd7\uff0c \u53cb\u6c38\u96c5\u5df3 \u76e3\u8a33"));
        Assertions.assertEquals((Object)"CLOSED", (Object)p_cleaned.getBestaccessright().getClassid());
        Assertions.assertNull((Object)p_out.getPublisher());
        Assertions.assertEquals((Object)"1970-10-07", (Object)p_cleaned.getDateofacceptance().getValue());
        Assertions.assertEquals((Object)"0038", (Object)((Instance)p_cleaned.getInstance().get(2)).getInstancetype().getClassid());
        Assertions.assertEquals((Object)"Other literature type", (Object)((Instance)p_cleaned.getInstance().get(2)).getInstancetype().getClassname());
        List pci = p_cleaned.getInstance();
        Assertions.assertNotNull((Object)pci);
        Assertions.assertEquals((int)3, (int)pci.size());
        Instance pcii = (Instance)pci.get(0);
        Assertions.assertNotNull((Object)pcii);
        Assertions.assertNotNull((Object)pcii.getPid());
        Assertions.assertEquals((int)2, (int)pcii.getPid().size());
        Assertions.assertTrue((boolean)pcii.getPid().stream().anyMatch(s -> s.getValue().equals("10.1007/s109090161569x")));
        Assertions.assertTrue((boolean)pcii.getPid().stream().anyMatch(s -> s.getValue().equals("10.1008/abcd")));
        Assertions.assertNotNull((Object)pcii.getAlternateIdentifier());
        Assertions.assertEquals((int)1, (int)pcii.getAlternateIdentifier().size());
        Assertions.assertTrue((boolean)pcii.getAlternateIdentifier().stream().anyMatch(s -> s.getValue().equals("10.1009/qwerty")));
        this.getAuthorPids((Result)p_cleaned).forEach(pid -> System.out.println(String.format("%s [%s - %s]", pid.getValue(), pid.getQualifier().getClassid(), pid.getQualifier().getClassname())));
        Assertions.assertTrue((boolean)p_cleaned.getAuthor().stream().anyMatch(a -> "Brien, Tom".equals(a.getFullname())));
        Assertions.assertNotNull((Object)p_cleaned.getSubject());
        List fos_subjects = p_cleaned.getSubject().stream().filter(s -> "FOS".equals(s.getQualifier().getClassid())).collect(Collectors.toList());
        Assertions.assertNotNull(fos_subjects);
        Assertions.assertEquals((int)3, (int)fos_subjects.size());
        Assertions.assertTrue((boolean)fos_subjects.stream().anyMatch(s -> "0101 mathematics".equals(s.getValue()) & "FOS".equals(s.getQualifier().getClassid()) & "subject:fos".equals(s.getDataInfo().getProvenanceaction().getClassid())));
        Assertions.assertTrue((boolean)fos_subjects.stream().anyMatch(s -> "0102 computer and information sciences".equals(s.getValue()) & "FOS".equals(s.getQualifier().getClassid()) & "subject:fos".equals(s.getDataInfo().getProvenanceaction().getClassid())));
        GraphCleaningFunctionsTest.verify_keyword(p_cleaned, "FOS: Computer and information sciences");
        GraphCleaningFunctionsTest.verify_keyword(p_cleaned, "FOS: Mathematics");
        System.out.println(MAPPER.writeValueAsString((Object)p_cleaned));
    }

    @Test
    void testCleaning_dataset() throws Exception {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertNotNull((Object)this.mapping);
        String json = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/result_dataset.json"));
        Dataset p_in = (Dataset)MAPPER.readValue(json, Dataset.class);
        Assertions.assertTrue((boolean)(p_in instanceof Result));
        Assertions.assertTrue((boolean)(p_in instanceof Dataset));
        Dataset p_out = (Dataset)OafCleaner.apply((Oaf)GraphCleaningFunctions.fixVocabularyNames((Oaf)p_in), (CleaningRuleMap)this.mapping);
        Assertions.assertNotNull((Object)p_out);
        Assertions.assertNotNull((Object)p_out.getPublisher());
        Assertions.assertNotNull((Object)p_out.getPublisher().getValue());
        Dataset p_cleaned = (Dataset)GraphCleaningFunctions.cleanup((Oaf)p_out, (VocabularyGroup)this.vocabularies);
        Assertions.assertEquals((Object)"Best publisher in the world", (Object)p_cleaned.getPublisher().getValue());
    }

    private static void verify_keyword(Publication p_cleaned, String subject) {
        Optional<Subject> s1 = p_cleaned.getSubject().stream().filter(s -> s.getValue().equals(subject)).findFirst();
        Assertions.assertTrue((boolean)s1.isPresent());
        Assertions.assertEquals((Object)"keyword", (Object)s1.get().getQualifier().getClassid());
        Assertions.assertEquals((Object)"keyword", (Object)s1.get().getQualifier().getClassname());
    }

    private Stream<Qualifier> getAuthorPidTypes(Result pub) {
        return pub.getAuthor().stream().map(Author::getPid).flatMap(Collection::stream).map(StructuredProperty::getQualifier);
    }

    private Stream<StructuredProperty> getAuthorPids(Result pub) {
        return pub.getAuthor().stream().map(Author::getPid).flatMap(Collection::stream);
    }

    private List<String> vocs() throws IOException {
        return IOUtils.readLines((InputStream)GraphCleaningFunctionsTest.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/terms.txt"));
    }

    private List<String> synonyms() throws IOException {
        return IOUtils.readLines((InputStream)GraphCleaningFunctionsTest.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/synonyms.txt"));
    }

    @Test
    public void testCleanDoiBoost() throws IOException {
        String json = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/doiboostpub.json"));
        Publication p_in = (Publication)MAPPER.readValue(json, Publication.class);
        Publication p_out = (Publication)OafCleaner.apply((Oaf)GraphCleaningFunctions.fixVocabularyNames((Oaf)p_in), (CleaningRuleMap)this.mapping);
        Publication cleaned = (Publication)GraphCleaningFunctions.cleanup((Oaf)p_out, (VocabularyGroup)this.vocabularies);
        Assertions.assertEquals((Object)true, (Object)GraphCleaningFunctions.filter((Oaf)cleaned));
    }

    @Test
    public void testFilterProject() throws IOException {
        String json = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/project.json"));
        Project p_in = (Project)MAPPER.readValue(json, Project.class);
        Assertions.assertEquals((Object)false, (Object)GraphCleaningFunctions.filter((Oaf)p_in));
    }

    @Test
    public void testCleanDoiBoost2() throws IOException {
        String json = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/doiboostpub2.json"));
        Publication p_in = (Publication)MAPPER.readValue(json, Publication.class);
        Publication p_out = (Publication)OafCleaner.apply((Oaf)GraphCleaningFunctions.fixVocabularyNames((Oaf)p_in), (CleaningRuleMap)this.mapping);
        Publication cleaned = (Publication)GraphCleaningFunctions.cleanup((Oaf)p_out, (VocabularyGroup)this.vocabularies);
        Assertions.assertEquals((Object)true, (Object)GraphCleaningFunctions.filter((Oaf)cleaned));
    }
}

